/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;

public class StartTagBuffer
extends ProxyReceiver
implements NamespaceResolver {
    int elementNameCode;
    int elementTypeCode;
    int elementLocationId;
    int elementProperties;
    AttributeCollectionImpl bufferedAttributes;
    boolean acceptAttributes;
    private int[] namespaces = new int[50];
    private int namespacesSize = 0;
    private int[] countStack = new int[50];
    private int depth = 0;
    private int attCount = 0;

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        super.setPipelineConfiguration(pipelineConfiguration);
        this.bufferedAttributes = new AttributeCollectionImpl(this.getNamePool());
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        this.elementNameCode = n;
        this.elementTypeCode = n2;
        this.elementLocationId = n3;
        this.elementProperties = n4;
        this.bufferedAttributes.clear();
        this.countStack[this.depth] = 0;
        if (++this.depth >= this.countStack.length) {
            int[] nArray = new int[this.depth * 2];
            System.arraycopy(this.countStack, 0, nArray, 0, this.depth);
            this.countStack = nArray;
        }
        this.acceptAttributes = true;
        if ((n4 & 0x40) == 0) {
            this.namespace(this.getNamePool().allocateNamespaceCode(n), 0);
        }
        this.attCount = 0;
    }

    public void namespace(int n, int n2) throws XPathException {
        if (!this.acceptAttributes) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(13, this.getNamePool().getPrefixFromNamespaceCode(n), this.getPipelineConfiguration().getController().getExecutable().getHostLanguage(), false, false);
        }
        for (int i = 0; i < this.countStack[this.depth - 1]; ++i) {
            if (this.namespaces[this.namespacesSize - 1 - i] != n) continue;
            return;
        }
        this.addToStack(n);
        int n3 = this.depth - 1;
        this.countStack[n3] = this.countStack[n3] + 1;
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (!this.acceptAttributes) {
            throw NoOpenStartTagException.makeNoOpenStartTagException(2, this.getNamePool().getDisplayName(n), this.getPipelineConfiguration().getController().getExecutable().getHostLanguage(), false, false);
        }
        if ((n4 & 0x40) == 0 && NamePool.getPrefixIndex(n) != 0) {
            n = this.checkProposedPrefix(n, this.attCount++);
        }
        this.bufferedAttributes.addAttribute(n, n2, ((Object)charSequence).toString(), n3, n4);
    }

    private void addToStack(int n) {
        if (this.namespacesSize + 1 >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesSize);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesSize++] = n;
    }

    public void startContent() throws XPathException {
        this.nextReceiver.startElement(this.elementNameCode, this.elementTypeCode, this.elementLocationId, this.elementProperties | 0x40);
        this.declareNamespacesForStartElement();
        int n = this.bufferedAttributes.getLength();
        for (int i = 0; i < n; ++i) {
            this.nextReceiver.attribute(this.bufferedAttributes.getNameCode(i), this.bufferedAttributes.getTypeAnnotation(i), this.bufferedAttributes.getValue(i), this.bufferedAttributes.getLocationId(i), this.bufferedAttributes.getProperties(i) | 0x40);
        }
        this.acceptAttributes = false;
        this.nextReceiver.startContent();
    }

    protected void declareNamespacesForStartElement() throws XPathException {
        for (int i = this.namespacesSize - this.countStack[this.depth - 1]; i < this.namespacesSize; ++i) {
            this.nextReceiver.namespace(this.namespaces[i], 0);
        }
    }

    protected void declareAllNamespaces() throws XPathException {
        for (int i = 0; i < this.namespacesSize; ++i) {
            this.nextReceiver.namespace(this.namespaces[i], 0);
        }
    }

    public void endElement() throws XPathException {
        this.nextReceiver.endElement();
        this.undeclareNamespacesForElement();
    }

    protected void undeclareNamespacesForElement() {
        int n = this.countStack[--this.depth];
        this.namespacesSize -= n;
    }

    public int getElementNameCode() {
        return this.elementNameCode;
    }

    public boolean hasAttributes() {
        return this.bufferedAttributes.getLength() > 0;
    }

    public String getAttribute(int n) {
        return this.bufferedAttributes.getValueByFingerprint(n & 0xFFFFF);
    }

    protected short getURICode(short s) {
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            if (this.namespaces[i] >> 16 != s) continue;
            short s2 = (short)(this.namespaces[i] & 0xFFFF);
            if (s2 == 0) break;
            return s2;
        }
        if (s == 0) {
            return 0;
        }
        return -1;
    }

    public String getURIForPrefix(String string, boolean bl) {
        NamePool namePool = this.getNamePool();
        if (!(string != null && string.length() != 0 || bl)) {
            return "";
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short s = namePool.getCodeForPrefix(string);
        short s2 = this.getURICode(s);
        if (s2 == -1) {
            return null;
        }
        return namePool.getURIFromURICode(s2);
    }

    public Iterator iteratePrefixes() {
        NamePool namePool = this.getNamePool();
        ArrayList<String> arrayList = new ArrayList<String>(this.namespacesSize);
        for (int i = this.namespacesSize - 1; i >= 0; --i) {
            String string = namePool.getPrefixFromNamespaceCode(this.namespaces[i]);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        arrayList.add("xml");
        return arrayList.iterator();
    }

    private int checkProposedPrefix(int n, int n2) throws XPathException {
        int n3;
        short s;
        NamePool namePool = this.getNamePool();
        int n4 = namePool.getNamespaceCode(n);
        if (n4 == -1) {
            n4 = namePool.allocateNamespaceCode(n);
        }
        if ((s = this.getURICode((short)(n3 = n4 >> 16))) == -1) {
            this.namespace(n4, 0);
            return n;
        }
        if ((n4 & 0xFFFF) == s) {
            return n;
        }
        String string = this.getSubstitutePrefix(n4, n2);
        int n5 = namePool.allocate(string, namePool.getURI(n), namePool.getLocalName(n));
        this.namespace(namePool.allocateNamespaceCode(n5), 0);
        return n5;
    }

    private String getSubstitutePrefix(int n, int n2) {
        String string = this.getNamePool().getPrefixFromNamespaceCode(n);
        return string + '_' + n2;
    }
}

