/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.source;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.source.CopletSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;

public class CopletSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
Serviceable,
ThreadSafe,
Contextualizable {
    protected ServiceManager manager;
    protected Context context;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.manager = serviceManager;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Source getSource(String location, Map parameters) throws MalformedURLException, IOException {
        CopletSource copletSource;
        String uri = location;
        String protocol = null;
        int position = location.indexOf(58) + 1;
        if (position != 0) {
            protocol = location.substring(0, position);
            location = location.substring(position + 2);
        }
        PortalService service = null;
        try {
            try {
                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                CopletInstanceData coplet = service.getComponentManager().getProfileManager().getCopletInstanceData(location);
                if (coplet == null) {
                    throw new IOException("Unable to get coplet for " + location);
                }
                CopletSource copletSource2 = new CopletSource(uri, protocol, coplet);
                copletSource2.contextualize(this.context);
                copletSource2.service(this.manager);
                copletSource = copletSource2;
                Object var11_12 = null;
            }
            catch (ContextException ce) {
                throw new SourceException("Unable to lookup profile manager.", (Throwable)ce);
            }
            catch (ServiceException ce) {
                throw new SourceException("Unable to lookup profile manager.", (Throwable)ce);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.manager.release((Object)service);
            throw throwable;
        }
        this.manager.release((Object)service);
        return copletSource;
    }

    public void release(Source source) {
    }
}

