/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.pluto.om.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.cocoon.portal.pluto.om.common.AbstractSupportSet;
import org.apache.cocoon.portal.pluto.om.common.LanguageImpl;
import org.apache.cocoon.portal.pluto.om.common.Support;
import org.apache.pluto.om.common.Language;
import org.apache.pluto.om.common.LanguageSet;
import org.apache.pluto.util.StringUtils;

public class LanguageSetImpl
extends AbstractSupportSet
implements LanguageSet,
Serializable,
Support {
    private String castorKeywords;
    private ClassLoader classLoader;
    private Vector locales = new Vector();
    private boolean resourceBundleInitialized;
    private String resources;
    private String shortTitle;
    private String title;

    private Language createLanguage(Locale locale, ResourceBundle bundle) {
        LanguageImpl lang = new LanguageImpl(locale, bundle, this.title, this.shortTitle, this.castorKeywords);
        return lang;
    }

    public Language get(Locale locale) {
        if (this.resources != null && !this.resourceBundleInitialized) {
            this.initResourceBundle();
            this.resourceBundleInitialized = true;
        }
        if (!this.locales.contains(locale)) {
            locale = this.matchLocale(locale);
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Language language = (Language)iterator.next();
            if (!language.getLocale().equals(locale) && this.size() != 1) continue;
            return language;
        }
        return null;
    }

    public Iterator getLocales() {
        return this.locales.iterator();
    }

    public Locale getDefaultLocale() {
        Locale defLoc = null;
        if (this.locales != null && this.locales.size() > 0) {
            defLoc = (Locale)this.locales.firstElement();
            if (defLoc == null) {
                defLoc = new Locale("en", "");
                this.locales.add(defLoc);
            }
        } else {
            defLoc = new Locale("en", "");
            this.locales.add(defLoc);
        }
        return defLoc;
    }

    public void postBuild(Object parameter) throws Exception {
    }

    public void postLoad(Object parameter) throws Exception {
        this.locales.addAll((Collection)parameter);
        this.initInlinedInfos();
    }

    public void postStore(Object parameter) throws Exception {
    }

    public void preBuild(Object parameter) throws Exception {
    }

    public void preStore(Object parameter) throws Exception {
    }

    private void initInlinedInfos() throws Exception {
        if (this.locales.isEmpty()) {
            this.getDefaultLocale();
        }
        if (this.castorKeywords == null) {
            this.castorKeywords = "";
        }
        if (this.shortTitle == null) {
            this.shortTitle = "";
        }
        if (this.title == null) {
            this.title = "";
        }
        this.add(this.createLanguage(this.getDefaultLocale(), null));
    }

    private void initResourceBundle() {
        Iterator iter = this.locales.iterator();
        while (iter.hasNext()) {
            Locale locale = (Locale)iter.next();
            ResourceBundle bundle = null;
            bundle = this.loadResourceBundle(locale);
            if (bundle == null) continue;
            Language language = this.createLanguage(locale, bundle);
            this.remove(language);
            this.add(language);
        }
    }

    private Locale matchLocale(Locale locale) {
        String country;
        String variant = locale.getVariant();
        if (variant != null && variant.length() > 0) {
            locale = new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (!this.locales.contains(locale) && (country = locale.getCountry()) != null && country.length() > 0) {
            locale = new Locale(locale.getLanguage(), "");
        }
        if (!this.locales.contains(locale)) {
            locale = this.getDefaultLocale();
        }
        return locale;
    }

    public String getCastorKeywords() {
        return this.castorKeywords;
    }

    public String getResources() {
        return this.resources;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public String getTitle() {
        return this.title;
    }

    protected ResourceBundle loadResourceBundle(Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this.classLoader != null ? ResourceBundle.getBundle(this.resources, locale, this.classLoader) : ResourceBundle.getBundle(this.resources, locale, Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException x) {
            return null;
        }
        return resourceBundle;
    }

    public void setCastorKeywords(String keywords) {
        this.castorKeywords = keywords;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public void setResources(String resources) {
        this.resources = resources;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer(50);
        StringUtils.newLine((StringBuffer)buffer, (int)indent);
        buffer.append(this.getClass().toString());
        buffer.append(": ");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            buffer.append(((LanguageImpl)iterator.next()).toString(indent + 2));
        }
        return buffer.toString();
    }
}

