/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.portal.PortalComponentManager;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.aspect.AspectDataHandler;
import org.apache.cocoon.portal.aspect.AspectDataStore;
import org.apache.cocoon.portal.aspect.AspectDescription;
import org.apache.cocoon.portal.aspect.impl.DefaultAspectDataHandler;
import org.apache.cocoon.portal.aspect.impl.DefaultAspectDescription;
import org.apache.cocoon.portal.coplet.CopletFactory;
import org.apache.cocoon.portal.event.Event;
import org.apache.cocoon.portal.event.EventManager;
import org.apache.cocoon.portal.event.Filter;
import org.apache.cocoon.portal.event.Subscriber;
import org.apache.cocoon.portal.event.impl.FullScreenCopletEvent;
import org.apache.cocoon.portal.event.impl.LayoutRemoveEvent;
import org.apache.cocoon.portal.layout.CompositeLayout;
import org.apache.cocoon.portal.layout.Item;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.LayoutFactory;
import org.apache.cocoon.portal.layout.impl.CopletLayout;
import org.apache.cocoon.portal.layout.impl.DefaultLayoutDescription;
import org.apache.cocoon.portal.layout.renderer.Renderer;
import org.apache.cocoon.portal.profile.ProfileManager;
import org.apache.cocoon.util.ClassUtils;

public class DefaultLayoutFactory
extends AbstractLogEnabled
implements ThreadSafe,
Component,
LayoutFactory,
Configurable,
Disposable,
Serviceable,
Initializable,
Subscriber {
    protected Map layouts = new HashMap();
    protected List descriptions = new ArrayList();
    protected ServiceSelector storeSelector;
    protected ServiceManager manager;
    protected Configuration[] layoutsConf;
    static /* synthetic */ Class class$org$apache$cocoon$portal$event$LayoutEvent;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.storeSelector = (ServiceSelector)this.manager.lookup(AspectDataStore.ROLE + "Selector");
    }

    protected void configureLayout(Configuration layoutConf) throws ConfigurationException {
        int m;
        DefaultLayoutDescription desc = new DefaultLayoutDescription();
        String name = layoutConf.getAttribute("name");
        if (this.layouts.get(name) != null) {
            throw new ConfigurationException("Layout name must be unique. Double definition for " + name);
        }
        desc.setName(name);
        desc.setClassName(layoutConf.getAttribute("class"));
        desc.setCreateId(layoutConf.getAttributeAsBoolean("create-id", false));
        String defaultRenderer = layoutConf.getChild("renderers").getAttribute("default");
        desc.setDefaultRendererName(defaultRenderer);
        Configuration[] rendererConfs = layoutConf.getChild("renderers").getChildren("renderer");
        if (rendererConfs != null) {
            boolean found = false;
            m = 0;
            while (m < rendererConfs.length) {
                String rName = rendererConfs[m].getAttribute("name");
                desc.addRendererName(rName);
                if (defaultRenderer.equals(rName)) {
                    found = true;
                }
                ++m;
            }
            if (!found) {
                throw new ConfigurationException("Default renderer '" + defaultRenderer + "' is not configured for layout '" + name + "'");
            }
        } else {
            throw new ConfigurationException("Default renderer '" + defaultRenderer + "' is not configured for layout '" + name + "'");
        }
        Configuration[] aspectsConf = layoutConf.getChild("aspects").getChildren("aspect");
        if (aspectsConf != null) {
            m = 0;
            while (m < aspectsConf.length) {
                AspectDescription adesc = DefaultAspectDescription.newInstance(aspectsConf[m]);
                desc.addAspectDescription(adesc);
                ++m;
            }
        }
        PortalService service = null;
        try {
            try {
                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                PortalComponentManager pcManager = service.getComponentManager();
                Iterator rendererIterator = desc.getRendererNames();
                while (rendererIterator.hasNext()) {
                    String rendererName = (String)rendererIterator.next();
                    Renderer renderer = pcManager.getRenderer(rendererName);
                    Iterator aspectIterator = renderer.getAspectDescriptions();
                    while (aspectIterator.hasNext()) {
                        AspectDescription adesc = (AspectDescription)aspectIterator.next();
                        desc.addAspectDescription(adesc);
                    }
                }
            }
            catch (ServiceException ce) {
                throw new ConfigurationException("Unable to lookup renderer selector.", (Throwable)ce);
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.manager.release((Object)service);
            throw throwable;
        }
        this.manager.release((Object)service);
        DefaultAspectDataHandler handler = new DefaultAspectDataHandler(desc, this.storeSelector);
        this.layouts.put(desc.getName(), new Object[]{desc, handler});
        this.descriptions.add(desc);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.layoutsConf = configuration.getChild("layouts").getChildren("layout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        if (this.layoutsConf != null) {
            DefaultLayoutFactory defaultLayoutFactory = this;
            synchronized (defaultLayoutFactory) {
                if (this.layoutsConf != null) {
                    int i = 0;
                    while (i < this.layoutsConf.length) {
                        try {
                            this.configureLayout(this.layoutsConf[i]);
                        }
                        catch (ConfigurationException ce) {
                            throw new CascadingRuntimeException("Unable to configure layout.", (Throwable)ce);
                        }
                        ++i;
                    }
                    this.layoutsConf = null;
                }
            }
        }
    }

    public void prepareLayout(Layout layout) throws ProcessingException {
        if (layout != null) {
            this.init();
            String layoutName = layout.getName();
            if (layoutName == null) {
                throw new ProcessingException("Layout '" + layout.getId() + "' has no associated name.");
            }
            Object[] o = (Object[])this.layouts.get(layoutName);
            if (o == null) {
                throw new ProcessingException("LayoutDescription with name '" + layoutName + "' not found.");
            }
            DefaultLayoutDescription layoutDescription = (DefaultLayoutDescription)o[0];
            layout.setDescription(layoutDescription);
            layout.setAspectDataHandler((AspectDataHandler)o[1]);
            if (layout instanceof CompositeLayout) {
                CompositeLayout composite = (CompositeLayout)layout;
                Iterator items = composite.getItems().iterator();
                while (items.hasNext()) {
                    this.prepareLayout(((Item)items.next()).getLayout());
                }
            }
        }
    }

    public Layout newInstance(String layoutName) throws ProcessingException {
        this.init();
        Object[] o = (Object[])this.layouts.get(layoutName);
        if (o == null) {
            throw new ProcessingException("LayoutDescription with name '" + layoutName + "' not found.");
        }
        DefaultLayoutDescription layoutDescription = (DefaultLayoutDescription)o[0];
        Layout layout = null;
        try {
            Class clazz = ClassUtils.loadClass((String)layoutDescription.getClassName());
            layout = (Layout)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to create new instance", (Throwable)e);
        }
        String id = null;
        if (layoutDescription.createId()) {
            id = layoutName + '-' + System.currentTimeMillis();
        }
        layout.initialize(layoutName, id);
        layout.setDescription(layoutDescription);
        layout.setAspectDataHandler((AspectDataHandler)o[1]);
        PortalService service = null;
        try {
            try {
                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                service.getComponentManager().getProfileManager().register(layout);
            }
            catch (ServiceException ce) {
                throw new ProcessingException("Unable to lookup profile manager.", (Throwable)ce);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.manager.release((Object)service);
            throw throwable;
        }
        this.manager.release((Object)service);
        return layout;
    }

    public List getLayoutDescriptions() {
        this.init();
        return this.descriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        if (this.manager != null) {
            block5: {
                EventManager eventManager = null;
                try {
                    try {
                        eventManager = (EventManager)this.manager.lookup(EventManager.ROLE);
                        eventManager.getRegister().unsubscribe(this);
                    }
                    catch (Exception ignore) {
                        Object var4_3 = null;
                        this.manager.release((Object)eventManager);
                        break block5;
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.manager.release((Object)eventManager);
                    throw throwable;
                }
                this.manager.release((Object)eventManager);
            }
            this.manager.release((Object)this.storeSelector);
            this.storeSelector = null;
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        EventManager eventManager = null;
        try {
            eventManager = (EventManager)this.manager.lookup(EventManager.ROLE);
            eventManager.getRegister().subscribe(this);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.manager.release((Object)eventManager);
            throw throwable;
        }
        this.manager.release((Object)eventManager);
    }

    public Filter getFilter() {
        return null;
    }

    public Class getEventType() {
        return class$org$apache$cocoon$portal$event$LayoutEvent == null ? (class$org$apache$cocoon$portal$event$LayoutEvent = DefaultLayoutFactory.class$("org.apache.cocoon.portal.event.LayoutEvent")) : class$org$apache$cocoon$portal$event$LayoutEvent;
    }

    public void inform(Event e) {
        if (e instanceof LayoutRemoveEvent) {
            LayoutRemoveEvent event = (LayoutRemoveEvent)e;
            Layout layout = (Layout)event.getTarget();
            try {
                this.remove(layout);
            }
            catch (ProcessingException pe) {
                throw new CascadingRuntimeException("Exception during removal.", (Throwable)pe);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Layout layout) throws ProcessingException {
        Item parent;
        if (layout == null) return;
        this.init();
        if (layout instanceof CompositeLayout) {
            Iterator itemIterator = ((CompositeLayout)layout).getItems().iterator();
            while (itemIterator.hasNext()) {
                this.remove(((Item)itemIterator.next()).getLayout());
            }
        }
        if ((parent = layout.getParent()) != null && parent.getParent() != null) {
            parent.getParent().removeItem(parent);
        }
        PortalService service = null;
        EventManager eventManager = null;
        try {
            try {
                service = (PortalService)this.manager.lookup(PortalService.ROLE);
                ProfileManager profileManager = service.getComponentManager().getProfileManager();
                if (layout instanceof CopletLayout) {
                    if (layout.equals(profileManager.getEntryLayout())) {
                        FullScreenCopletEvent event = new FullScreenCopletEvent(((CopletLayout)layout).getCopletInstanceData(), null);
                        eventManager = (EventManager)this.manager.lookup(EventManager.ROLE);
                        eventManager.getPublisher().publish(event);
                        service.getComponentManager().getLinkService().addEventToLink(event);
                    }
                    CopletFactory factory = service.getComponentManager().getCopletFactory();
                    factory.remove(((CopletLayout)layout).getCopletInstanceData());
                }
                profileManager.unregister(layout);
            }
            catch (ServiceException ce) {
                throw new ProcessingException("Unable to lookup portal service.", (Throwable)ce);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.manager.release((Object)service);
            this.manager.release(eventManager);
            throw throwable;
        }
        this.manager.release((Object)service);
        this.manager.release(eventManager);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

