/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.portlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.environment.portlet.ActionRequest;
import org.apache.cocoon.environment.portlet.PortletResponse;
import org.apache.cocoon.util.NetUtils;

public final class ActionResponse
extends PortletResponse {
    private String uri;
    private ActionRequest request;

    protected ActionResponse(javax.portlet.ActionResponse response, PortletPreferences preferences, ActionRequest request, String uri) {
        super((javax.portlet.PortletResponse)response, preferences);
        this.request = request;
        this.uri = uri;
    }

    public void addHeader(String name, String value) {
        if ("X-Portlet-Mode".equals(name)) {
            try {
                this.getActionResponse().setPortletMode(new PortletMode(value));
            }
            catch (PortletModeException e) {
                throw new CascadingRuntimeException("Cant set portlet mode '" + value + "'", (Throwable)e);
            }
        } else if ("X-Window-State".equals(name)) {
            try {
                this.getActionResponse().setWindowState(new WindowState(value));
            }
            catch (WindowStateException e) {
                throw new CascadingRuntimeException("Cant set window state '" + value + "'", (Throwable)e);
            }
        } else {
            super.addHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        if ("X-Portlet-Mode".equals(name)) {
            try {
                this.getActionResponse().setPortletMode(new PortletMode(value));
            }
            catch (PortletModeException e) {
                throw new CascadingRuntimeException("Cant set portlet mode '" + value + "'", (Throwable)e);
            }
        } else if ("X-Window-State".equals(name)) {
            try {
                this.getActionResponse().setWindowState(new WindowState(value));
            }
            catch (WindowStateException e) {
                throw new CascadingRuntimeException("Cant set window state '" + value + "'", (Throwable)e);
            }
        } else {
            super.setHeader(name, value);
        }
    }

    public void sendRedirect(String location) throws IOException {
        String servletPath = this.request.getServletPath();
        HashMap parameters = new HashMap(7);
        String absLoc = NetUtils.deparameterize((String)location, parameters);
        if (absLoc.length() > 0) {
            String base = NetUtils.getPath((String)this.uri);
            absLoc = NetUtils.absolutize((String)base, (String)absLoc);
            absLoc = NetUtils.normalize((String)absLoc);
        } else {
            absLoc = this.uri;
        }
        if (absLoc.startsWith(servletPath)) {
            String pathInfo = absLoc.substring(servletPath.length());
            Iterator i = parameters.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String value = (String)parameters.get(name);
                this.getActionResponse().setRenderParameter(name, value);
            }
            this.getActionResponse().setRenderParameter("cocoon-portlet-path", pathInfo);
        } else {
            this.getActionResponse().sendRedirect(location);
        }
    }

    public javax.portlet.ActionResponse getActionResponse() {
        return (javax.portlet.ActionResponse)this.getPortletResponse();
    }

    public void setPortletMode(PortletMode mode) throws PortletModeException {
        this.getActionResponse().setPortletMode(mode);
    }

    public void setRenderParameter(String key, String value) {
        this.getActionResponse().setRenderParameter(key, value);
    }

    public void setRenderParameter(String key, String[] values) {
        this.getActionResponse().setRenderParameter(key, values);
    }

    public void setRenderParameters(Map parameters) {
        this.getActionResponse().setRenderParameters(parameters);
    }

    public void setWindowState(WindowState state) throws WindowStateException {
        this.getActionResponse().setWindowState(state);
    }

    boolean isCommitted() {
        return true;
    }
}

