/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.variables;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.variables.NOPVariableResolver;
import org.apache.cocoon.sitemap.PatternException;

public class PreparedVariableResolver
extends NOPVariableResolver {
    protected ServiceManager manager;
    protected ServiceSelector selector;
    protected Context context;
    protected List items = new ArrayList();
    static final int LITERAL = -2;
    static final int THREADSAFE_MODULE = -3;
    static final int STATEFUL_MODULE = -4;
    private static final Integer LITERAL_OBJ = new Integer(-2);
    private static final Integer THREADSAFE_MODULE_OBJ = new Integer(-3);
    private static final Integer STATEFUL_MODULE_OBJ = new Integer(-4);

    public PreparedVariableResolver(String expr, ServiceManager manager, Context context) throws PatternException {
        super(null);
        this.expression = expr;
        this.manager = manager;
        this.context = context;
        int length = expr.length();
        int prev = 0;
        while (prev < length) {
            int end;
            int pos = prev;
            while (pos < length && (pos = expr.indexOf(123, pos)) != -1 && pos != 0 && expr.charAt(pos - 1) == '\\') {
                ++pos;
            }
            if (pos >= length || pos == -1) {
                if (prev >= length) break;
                this.addLiteral(expr.substring(prev));
                break;
            }
            if (prev < ++pos - 1) {
                this.addLiteral(expr.substring(prev, pos - 1));
            }
            if ((end = expr.indexOf(125, pos)) == -1) {
                throw new PatternException("Unmatched '{' in " + expr);
            }
            int colon = expr.indexOf(58, pos);
            if (colon == -1 || colon >= end) {
                throw new PatternException("Unknown variable format " + expr.substring(pos, end));
            }
            String module = expr.substring(pos, colon);
            String variable = expr.substring(colon + 1, end);
            this.addModuleVariable(module, variable);
            prev = end + 1;
        }
    }

    protected void addLiteral(String litteral) {
        this.items.add(LITERAL_OBJ);
        this.items.add(litteral);
    }

    protected void addModuleVariable(String moduleName, String variable) throws PatternException {
        InputModule module;
        if (this.selector == null) {
            try {
                this.selector = (ServiceSelector)this.manager.lookup(InputModule.ROLE + "Selector");
            }
            catch (ServiceException ce) {
                throw new PatternException("Cannot access input modules selector", (Throwable)ce);
            }
        }
        try {
            module = (InputModule)this.selector.select((Object)moduleName);
        }
        catch (ServiceException ce) {
            throw new PatternException("Cannot get InputModule named '" + moduleName + "' in expression '" + this.expression + "'", (Throwable)ce);
        }
        if (module instanceof ThreadSafe) {
            this.items.add(THREADSAFE_MODULE_OBJ);
            this.items.add(module);
            this.items.add(variable);
        } else {
            this.selector.release((Object)module);
            this.items.add(STATEFUL_MODULE_OBJ);
            this.items.add(moduleName);
            this.items.add(variable);
        }
    }

    /*
     * Unable to fully structure code
     */
    public String resolve() throws PatternException {
        result = new StringBuffer();
        i = 0;
        while (i < this.items.size()) {
            type = (Integer)this.items.get(i);
            switch (type) {
                case -2: {
                    result.append(this.items.get(++i));
                    break;
                }
                case -3: {
                    module = (InputModule)this.items.get(++i);
                    variable = (String)this.items.get(++i);
                    try {
                        value = module.getAttribute(variable, null, ContextHelper.getObjectModel((Context)this.context));
                        if (value == null) break;
                        result.append(value);
                        break;
                    }
                    catch (ConfigurationException confEx) {
                        throw new PatternException("Cannot get variable '" + variable + "' in expression '" + this.expression + "'", (Throwable)confEx);
                    }
                }
                case -4: {
                    module = null;
                    moduleName = (String)this.items.get(++i);
                    variableName = (String)this.items.get(++i);
                    try {
                        module = (InputModule)this.selector.select((Object)moduleName);
                        value = module.getAttribute(variableName, null, ContextHelper.getObjectModel((Context)this.context));
                        if (value == null) ** GOTO lbl33
                        result.append(value);
lbl33:
                        // 2 sources

                        var10_10 = null;
                    }
                    catch (Throwable var9_12) {
                        var10_10 = null;
                        this.selector.release((Object)module);
                        throw var9_12;
                    }
                    this.selector.release((Object)module);
                    break;
                    {
                        catch (ServiceException compEx) {
                            throw new PatternException("Cannot get module '" + moduleName + "' in expression '" + this.expression + "'", (Throwable)compEx);
                        }
                        catch (ConfigurationException confEx) {
                            throw new PatternException("Cannot get variable '" + variableName + "' in expression '" + this.expression + "'", (Throwable)confEx);
                        }
                    }
                }
            }
            ++i;
        }
        return result.toString();
    }

    public void dispose() {
        super.dispose();
        if (this.selector != null) {
            int i = 0;
            while (i < this.items.size()) {
                int type = (Integer)this.items.get(i);
                switch (type) {
                    case -2: {
                        ++i;
                        break;
                    }
                    case -3: {
                        this.selector.release(this.items.get(++i));
                        ++i;
                        break;
                    }
                    case -4: {
                        i += 2;
                        break;
                    }
                }
                ++i;
            }
            this.manager.release((Object)this.selector);
            this.selector = null;
            this.manager = null;
        }
    }
}

