/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.CopyElementsOperation;
import org.eclipse.jdt.internal.core.CopyResourceElementsOperation;
import org.eclipse.jdt.internal.core.DeleteElementsOperation;
import org.eclipse.jdt.internal.core.DeleteResourceElementsOperation;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.MoveElementsOperation;
import org.eclipse.jdt.internal.core.MoveResourceElementsOperation;
import org.eclipse.jdt.internal.core.MultiOperation;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.RenameElementsOperation;
import org.eclipse.jdt.internal.core.RenameResourceElementsOperation;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;

public class JavaModel
extends Openable
implements IJavaModel {
    public static HashSet existingExternalFiles = new HashSet();

    protected JavaModel() throws Error {
        super(null, "");
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        int max = projects.length;
        while (i < max) {
            IProject project = projects[i];
            if (JavaProject.hasJavaNature(project)) {
                info.addChild(this.getJavaProject((IResource)project));
            }
            ++i;
        }
        newElements.put(this, info);
        return true;
    }

    public boolean contains(IResource resource) {
        IJavaProject[] projects;
        switch (resource.getType()) {
            case 4: 
            case 8: {
                return true;
            }
        }
        try {
            projects = this.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        int i = 0;
        int length = projects.length;
        while (i < length) {
            JavaProject project = (JavaProject)projects[i];
            if (!project.contains(resource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void copy(IJavaElement[] elements, IJavaElement[] containers, IJavaElement[] siblings, String[] renamings, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            this.runOperation(new CopyResourceElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        } else {
            this.runOperation(new CopyElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        }
    }

    protected Object createElementInfo() {
        return new JavaModelInfo();
    }

    public void delete(IJavaElement[] elements, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            new DeleteResourceElementsOperation(elements, force).runOperation(monitor);
        } else {
            new DeleteElementsOperation(elements, force).runOperation(monitor);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof JavaModel)) {
            return false;
        }
        return super.equals(o);
    }

    public IJavaProject findJavaProject(IProject project) {
        try {
            IJavaProject[] projects = this.getOldJavaProjectsList();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                IJavaProject javaProject = projects[i];
                if (project.equals((Object)javaProject.getProject())) {
                    return javaProject;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public int getElementType() {
        return 1;
    }

    public static void flushExternalFileCache() {
        existingExternalFiles = new HashSet();
    }

    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
            case '=': {
                String projectName = memento.nextToken();
                JavaElement project = (JavaElement)((Object)this.getJavaProject(projectName));
                return project.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    public String getHandleMemento() {
        return this.getElementName();
    }

    protected char getHandleMementoDelimiter() {
        Assert.isTrue(false, "Should not be called");
        return '\u0000';
    }

    public IJavaProject getJavaProject(String projectName) {
        return new JavaProject(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), this);
    }

    public IJavaProject getJavaProject(IResource resource) {
        switch (resource.getType()) {
            case 2: {
                return new JavaProject(((IFolder)resource).getProject(), this);
            }
            case 1: {
                return new JavaProject(((IFile)resource).getProject(), this);
            }
            case 4: {
                return new JavaProject((IProject)resource, this);
            }
        }
        throw new IllegalArgumentException(Util.bind("element.invalidResourceForProject"));
    }

    public IJavaProject[] getJavaProjects() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(2);
        IJavaProject[] array = new IJavaProject[list.size()];
        list.toArray(array);
        return array;
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        return ((JavaModelInfo)this.getElementInfo()).getNonJavaResources();
    }

    public IJavaProject[] getOldJavaProjectsList() throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        return manager.deltaState.modelProjectsCache == null ? this.getJavaProjects() : manager.deltaState.modelProjectsCache;
    }

    public IPath getPath() {
        return Path.ROOT;
    }

    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void move(IJavaElement[] elements, IJavaElement[] containers, IJavaElement[] siblings, String[] renamings, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            this.runOperation(new MoveResourceElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        } else {
            this.runOperation(new MoveElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        }
    }

    public void refreshExternalArchives(IJavaElement[] elementsScope, IProgressMonitor monitor) throws JavaModelException {
        if (elementsScope == null) {
            elementsScope = new IJavaElement[]{this};
        }
        JavaModelManager.getJavaModelManager().getDeltaProcessor().checkExternalArchiveChanges(elementsScope, monitor);
    }

    public void rename(IJavaElement[] elements, IJavaElement[] destinations, String[] renamings, boolean force, IProgressMonitor monitor) throws JavaModelException {
        MultiOperation op = elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7 ? new RenameResourceElementsOperation(elements, destinations, renamings, force) : new RenameElementsOperation(elements, destinations, renamings, force);
        op.runOperation(monitor);
    }

    protected void runOperation(MultiOperation op, IJavaElement[] elements, IJavaElement[] siblings, String[] renamings, IProgressMonitor monitor) throws JavaModelException {
        op.setRenamings(renamings);
        if (siblings != null) {
            int i = 0;
            while (i < elements.length) {
                op.setInsertBefore(elements[i], siblings[i]);
                ++i;
            }
        }
        op.runOperation(monitor);
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append("Java Model");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    public static Object getTarget(IContainer container, IPath path, boolean checkResourceExistence) {
        IResource resource;
        if (path == null) {
            return null;
        }
        if (path.getDevice() == null && (resource = container.findMember(path)) != null) {
            if (!checkResourceExistence || resource.exists()) {
                return resource;
            }
            return null;
        }
        if (!path.isAbsolute()) {
            return null;
        }
        File externalFile = new File(path.toOSString());
        if (!checkResourceExistence) {
            return externalFile;
        }
        if (existingExternalFiles.contains(externalFile)) {
            return externalFile;
        }
        if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [JavaModel.getTarget(...)] Checking existence of " + path.toString());
        }
        if (externalFile.exists()) {
            existingExternalFiles.add(externalFile);
            return externalFile;
        }
        return null;
    }
}

