/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SingleTypeReference
extends TypeReference {
    public char[] token;

    public SingleTypeReference(char[] source, long pos) {
        this.token = source;
        this.sourceStart = (int)(pos >>> 32);
        this.sourceEnd = (int)(pos & 0xFFFFFFFFL);
    }

    public SingleTypeReference(char[] source, TypeBinding type, long pos) {
        this(source, pos);
        this.resolvedType = type;
    }

    public TypeReference copyDims(int dim) {
        return new ArrayTypeReference(this.token, null, dim, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    public TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        return scope.getType(this.token);
    }

    public char[][] getTypeName() {
        return new char[][]{this.token};
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        return output.append(this.token);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope scope, ReferenceBinding enclosingType) {
        ReferenceBinding memberTb = scope.getMemberType(this.token, enclosingType);
        if (!memberTb.isValidBinding()) {
            scope.problemReporter().invalidEnclosingType(this, memberTb, enclosingType);
            return null;
        }
        if (this.isTypeUseDeprecated(memberTb, scope)) {
            scope.problemReporter().deprecatedType(memberTb, this);
        }
        this.resolvedType = memberTb;
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

