/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.xml.sax.XMLizable;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XSPObjectHelper {
    protected static void elementData(String uri, String prefix, ContentHandler contentHandler, String name, String data) throws SAXException {
        XSPObjectHelper.start(uri, prefix, contentHandler, name);
        XSPObjectHelper.data(contentHandler, data);
        XSPObjectHelper.end(uri, prefix, contentHandler, name);
    }

    protected static void elementData(String uri, String prefix, ContentHandler contentHandler, String name, String data, AttributesImpl attr) throws SAXException {
        XSPObjectHelper.start(uri, prefix, contentHandler, name, attr);
        XSPObjectHelper.data(contentHandler, data);
        XSPObjectHelper.end(uri, prefix, contentHandler, name);
    }

    protected static void start(String uri, String prefix, ContentHandler contentHandler, String name) throws SAXException {
        contentHandler.startElement(uri, name, prefix + ":" + name, XMLUtils.EMPTY_ATTRIBUTES);
    }

    protected static void start(String uri, String prefix, ContentHandler contentHandler, String name, AttributesImpl attr) throws SAXException {
        contentHandler.startElement(uri, name, prefix + ":" + name, attr);
    }

    protected static void end(String uri, String prefix, ContentHandler contentHandler, String name) throws SAXException {
        contentHandler.endElement(uri, name, prefix + ":" + name);
    }

    protected static void addAttribute(AttributesImpl attr, String name, String value) throws SAXException {
        attr.addAttribute("", name, name, "CDATA", value);
    }

    protected static void data(ContentHandler contentHandler, String data) throws SAXException {
        contentHandler.characters(data.toCharArray(), 0, data.length());
    }

    public static void xspExpr(ContentHandler contentHandler, char v) throws SAXException {
        XSPObjectHelper.data(contentHandler, String.valueOf(v));
    }

    public static void xspExpr(ContentHandler contentHandler, byte v) throws SAXException {
        XSPObjectHelper.data(contentHandler, String.valueOf(v));
    }

    public static void xspExpr(ContentHandler contentHandler, boolean v) throws SAXException {
        XSPObjectHelper.data(contentHandler, String.valueOf(v));
    }

    public static void xspExpr(ContentHandler contentHandler, int v) throws SAXException {
        XSPObjectHelper.data(contentHandler, String.valueOf(v));
    }

    public static void xspExpr(ContentHandler contentHandler, long v) throws SAXException {
        XSPObjectHelper.data(contentHandler, String.valueOf(v));
    }

    public static void xspExpr(ContentHandler contentHandler, float v) throws SAXException {
        XSPObjectHelper.data(contentHandler, String.valueOf(v));
    }

    public static void xspExpr(ContentHandler contentHandler, double v) throws SAXException {
        XSPObjectHelper.data(contentHandler, String.valueOf(v));
    }

    public static void xspExpr(ContentHandler contentHandler, String text) throws SAXException {
        if (text != null) {
            XSPObjectHelper.data(contentHandler, text);
        }
    }

    public static void xspExpr(ContentHandler contentHandler, XMLizable v) throws SAXException {
        if (v != null) {
            v.toSAX(contentHandler);
        }
    }

    public static void xspExpr(ContentHandler contentHandler, Node v) throws SAXException {
        if (v != null) {
            DOMStreamer streamer = new DOMStreamer(contentHandler);
            streamer.stream(v);
        }
    }

    public static void xspExpr(ContentHandler contentHandler, Collection v) throws SAXException {
        if (v != null) {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                XSPObjectHelper.xspExpr(contentHandler, iterator.next());
            }
        }
    }

    public static void xspExpr(ContentHandler contentHandler, Object v) throws SAXException {
        if (v == null) {
            return;
        }
        if (v.getClass().isArray()) {
            Object[] elements = (Object[])v;
            for (int i = 0; i < elements.length; ++i) {
                XSPObjectHelper.xspExpr(contentHandler, elements[i]);
            }
            return;
        }
        if (v instanceof XMLizable) {
            XSPObjectHelper.xspExpr(contentHandler, (XMLizable)v);
            return;
        }
        if (v instanceof Node) {
            XSPObjectHelper.xspExpr(contentHandler, (Node)v);
            return;
        }
        if (v instanceof Collection) {
            XSPObjectHelper.xspExpr(contentHandler, (Collection)v);
            return;
        }
        XSPObjectHelper.data(contentHandler, String.valueOf(v));
    }
}

