/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.renderer;

import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.components.renderer.RendererFactory;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pcl.PCLRenderer;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.render.ps.PSRenderer;

public class ExtendableRendererFactory
implements RendererFactory {
    protected static final Map renderers = new HashMap();
    protected static final RendererFactory singleton = new ExtendableRendererFactory();

    private ExtendableRendererFactory() {
        this.addRenderer("application/pdf", PDFRenderer.class);
        this.addRenderer("application/postscript", PSRenderer.class);
        this.addRenderer("application/vnd.hp-PCL", PCLRenderer.class);
    }

    public static final RendererFactory getRendererFactoryImplementation() {
        return singleton;
    }

    public Renderer createRenderer(String mimeType) {
        Class rendererClass = (Class)renderers.get(mimeType);
        if (rendererClass == null) {
            return null;
        }
        try {
            return (Renderer)rendererClass.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void addRenderer(String mimeType, Class rendererClass) {
        renderers.put(mimeType, rendererClass);
    }

    public void removeRenderer(String mimeType) {
        renderers.remove(mimeType);
    }
}

