/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverters;

class CharacterSetZHTEUC
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterZHTEUC";
    static final int MAX_7BIT = 127;
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;

    CharacterSetZHTEUC(int n, CharacterConverters characterConverters) {
        super(n, characterConverters);
        this.m_leadingCodes = characterConverters.getLeadingCodes();
    }

    static CharacterSetZHTEUC getInstance(int n, CharacterConverters characterConverters) {
        if (characterConverters.getGroupId() == 5) {
            return new CharacterSetZHTEUC(n, characterConverters);
        }
        return null;
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        int n;
        if (characterWalker.next + 1 < characterWalker.bytes.length) {
            n = characterWalker.bytes[characterWalker.next] << 8 | characterWalker.bytes[characterWalker.next + 1];
            for (int i = 0; i < this.m_leadingCodes.length; ++i) {
                if (n != this.m_leadingCodes[i]) continue;
                if (characterWalker.bytes.length - characterWalker.next < 4) {
                    throw new SQLException("destination too small");
                }
                int n2 = 0;
                for (int j = 0; j < 4; ++j) {
                    n2 = n2 << 8 | characterWalker.bytes[characterWalker.next++];
                }
                return n2;
            }
        }
        n = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n > 127) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n = n << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                throw new SQLException("destination too small");
            }
        }
        return n;
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        int n2 = n >> 16;
        for (int i = 0; i < this.m_leadingCodes.length; ++i) {
            if (n2 != this.m_leadingCodes[i]) continue;
            CharacterSetZHTEUC.need(characterBuffer, 4);
            for (int j = 0; j < 4; ++j) {
                characterBuffer.bytes[characterBuffer.next++] = (byte)n;
                n >>= 8;
            }
            return;
        }
        throw new SQLException();
    }
}

