/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;

class OracleReturnResultSet
extends BaseResultSet {
    OracleStatement statement;
    boolean closed;
    Accessor[] returnAccessors;

    OracleReturnResultSet(OracleStatement oracleStatement) throws SQLException {
        this.statement = oracleStatement;
        this.closed = false;
        this.returnAccessors = new Accessor[oracleStatement.numReturnParams];
        int n = 0;
        for (int i = 0; i < oracleStatement.numberOfBindPositions; ++i) {
            Accessor accessor = oracleStatement.returnParamAccessors[i];
            if (accessor == null) continue;
            this.returnAccessors[n++] = accessor;
        }
    }

    public synchronized boolean next() throws SQLException {
        if (this.closed) {
            return false;
        }
        if (!this.statement.returnParamsFetched) {
            this.statement.fetchDmlReturnParams();
            this.statement.setupReturnParamAccessors();
        }
        ++this.statement.currentRow;
        ++this.statement.totalRowsVisited;
        return this.statement.currentRow < this.statement.rowsDmlReturned;
    }

    public synchronized void close() throws SQLException {
        this.closed = true;
        this.statement.returnResultSet = null;
        this.statement.numReturnParams = 0;
        this.statement.totalRowsVisited = 0;
        this.statement.currentRow = -1;
        this.statement.returnParamsFetched = false;
        this.statement.rowsDmlReturned = 0;
        this.statement.returnParamBytes = null;
        this.statement.returnParamChars = null;
        this.statement.returnParamIndicators = null;
    }

    public synchronized boolean wasNull() throws SQLException {
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (this.statement.currentRow == -1 || this.statement.lastIndex == 0) {
            DatabaseError.throwSqlException(24);
        }
        return this.returnAccessors[this.statement.lastIndex - 1].isNull(this.statement.currentRow);
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (!this.statement.isAutoGeneratedKey) {
            DatabaseError.throwSqlException(23);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(10);
        }
        if (this.statement.closed) {
            DatabaseError.throwSqlException(9);
        }
        AutoKeyInfo autoKeyInfo = this.statement.autoKeyInfo;
        autoKeyInfo.statement = this.statement;
        autoKeyInfo.connection = this.statement.connection;
        autoKeyInfo.initMetaData(this);
        return autoKeyInfo;
    }

    public synchronized Statement getStatement() throws SQLException {
        return this.statement;
    }

    public synchronized String getString(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getString(n2);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getBoolean(n2);
    }

    public synchronized byte getByte(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getByte(n2);
    }

    public synchronized short getShort(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getShort(n2);
    }

    public synchronized int getInt(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getInt(n2);
    }

    public synchronized long getLong(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getLong(n2);
    }

    public synchronized float getFloat(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getFloat(n2);
    }

    public synchronized double getDouble(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getDouble(n2);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        int n3;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n3 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getBigDecimal(n3, n2);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getBytes(n2);
    }

    public synchronized Date getDate(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getDate(n2);
    }

    public synchronized Time getTime(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getTime(n2);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getTimestamp(n2);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized Object getObject(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getObject(n2);
    }

    public synchronized ResultSet getCursor(int n) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized Datum getOracleObject(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getOracleObject(n2);
    }

    public synchronized ROWID getROWID(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getROWID(n2);
    }

    public synchronized NUMBER getNUMBER(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getNUMBER(n2);
    }

    public synchronized DATE getDATE(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getDATE(n2);
    }

    public synchronized ARRAY getARRAY(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getARRAY(n2);
    }

    public synchronized STRUCT getSTRUCT(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getSTRUCT(n2);
    }

    public synchronized OPAQUE getOPAQUE(int n) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized REF getREF(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getREF(n2);
    }

    public synchronized CHAR getCHAR(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getCHAR(n2);
    }

    public synchronized RAW getRAW(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getRAW(n2);
    }

    public synchronized BLOB getBLOB(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getBLOB(n2);
    }

    public synchronized CLOB getCLOB(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getCLOB(n2);
    }

    public synchronized BFILE getBFILE(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getBFILE(n2);
    }

    public synchronized BFILE getBfile(int n) throws SQLException {
        return this.getBFILE(n);
    }

    public synchronized CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized ORAData getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getORAData(n2, oRADataFactory);
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getObject(n2, map);
    }

    public synchronized Ref getRef(int n) throws SQLException {
        return this.getREF(n);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        return this.getBLOB(n);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        return this.getCLOB(n);
    }

    public synchronized Array getArray(int n) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getBigDecimal(n2);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getDate(n2, calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getTime(n2, calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getTimestamp(n2, calendar);
    }

    public INTERVALYM getINTERVALYM(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getINTERVALYM(n2);
    }

    public INTERVALDS getINTERVALDS(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getINTERVALDS(n2);
    }

    public TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getTIMESTAMP(n2);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getTIMESTAMPLTZ(n2);
    }

    public synchronized URL getURL(int n) throws SQLException {
        int n2;
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (n <= 0 || n > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((n2 = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = n;
        return this.returnAccessors[n - 1].getURL(n2);
    }

    public boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.statement.currentRow == -1 && !this.closed;
    }

    public boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.closed;
    }

    public boolean isFirst() throws SQLException {
        return this.getRow() == 1;
    }

    public boolean isLast() throws SQLException {
        return this.getRow() == this.statement.rowsDmlReturned;
    }

    public int getRow() throws SQLException {
        return this.statement.totalRowsVisited;
    }

    public synchronized int findColumn(String string) throws SQLException {
        DatabaseError.throwSqlException(23);
        return -1;
    }

    public void setFetchSize(int n) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    public int getFetchSize() throws SQLException {
        DatabaseError.throwSqlException(23);
        return -1;
    }

    boolean isEmptyResultSet() {
        return this.statement.rowsDmlReturned == 0;
    }
}

