/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.location;

import java.io.Serializable;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationUtils;
import org.apache.commons.lang.ObjectUtils;

public class LocationImpl
implements Location,
Serializable {
    static final LocationImpl UNKNOWN = new LocationImpl(null, null, -1, -1);
    private final String uri;
    private final int line;
    private final int column;
    private final String description;

    public LocationImpl(String description, String uri) {
        this(description, uri, -1, -1);
    }

    public LocationImpl(String description, String uri, int line, int column) {
        if (uri == null || uri.length() == 0) {
            this.uri = null;
            this.line = -1;
            this.column = -1;
        } else {
            this.uri = uri;
            this.line = line;
            this.column = column;
        }
        if (description != null && description.length() == 0) {
            description = null;
        }
        this.description = description;
    }

    public LocationImpl(Location location) {
        this(location.getDescription(), location.getURI(), location.getLineNumber(), location.getColumnNumber());
    }

    public LocationImpl(String description, Location location) {
        this(description, location.getURI(), location.getLineNumber(), location.getColumnNumber());
    }

    public static LocationImpl get(Location location) {
        if (location instanceof LocationImpl) {
            return (LocationImpl)location;
        }
        if (location == null) {
            return UNKNOWN;
        }
        return new LocationImpl(location);
    }

    public String getDescription() {
        return this.description;
    }

    public String getURI() {
        return this.uri;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Location) {
            Location other = (Location)obj;
            return this.line == other.getLineNumber() && this.column == other.getColumnNumber() && ObjectUtils.equals((Object)this.uri, (Object)other.getURI()) && ObjectUtils.equals((Object)this.description, (Object)other.getDescription());
        }
        return false;
    }

    public int hashCode() {
        int hash = this.line ^ this.column;
        if (this.uri != null) {
            hash ^= this.uri.hashCode();
        }
        if (this.description != null) {
            hash ^= this.description.hashCode();
        }
        return hash;
    }

    public String toString() {
        return LocationUtils.toString(this);
    }

    private Object readResolve() {
        return this.equals(Location.UNKNOWN) ? Location.UNKNOWN : this;
    }
}

