/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.jxpath;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMFactory
extends AbstractFactory {
    public boolean createObject(JXPathContext context, Pointer pointer, Object parent, String name, int index) {
        this.addDOMElement((Node)parent, index, name);
        return true;
    }

    private void addDOMElement(Node parent, int index, String tag) {
        int pos = tag.indexOf(58);
        String prefix = null;
        if (pos != -1) {
            prefix = tag.substring(0, pos);
        }
        String uri = null;
        int count = 0;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(tag)) continue;
            ++count;
        }
        Document doc = parent.getOwnerDocument();
        if (doc != null) {
            uri = this.getNamespaceURI((Element)parent, prefix);
        } else if (parent instanceof Document) {
            doc = (Document)parent;
            if (prefix != null) {
                throw new RuntimeException("Cannot map non-null prefix when creating a document element");
            }
        } else {
            throw new RuntimeException("Node of class " + parent.getClass().getName() + " has null owner document " + "but is not a Document");
        }
        while (count <= index) {
            Element newElement = doc.createElementNS(uri, tag);
            parent.appendChild(newElement);
            ++count;
        }
    }

    public String getNamespaceURI(Element element, String prefix) {
        String nsAttr;
        String string = nsAttr = prefix == null ? "xmlns" : "xmlns:" + prefix;
        for (Node tmp = element; tmp != null && tmp.getNodeType() == 1; tmp = tmp.getParentNode()) {
            element = tmp;
            if (prefix == null ? element.getPrefix() == null : prefix.equals(element.getPrefix())) {
                return element.getNamespaceURI();
            }
            Attr nsAttrNode = tmp.getAttributeNode(nsAttr);
            if (nsAttrNode == null) continue;
            return nsAttrNode.getValue();
        }
        return null;
    }

    public boolean declareVariable(JXPathContext context, String name) {
        return false;
    }
}

