/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store.impl;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.store.impl.StoreJanitorImpl;
import org.apache.cocoon.components.thread.RunnableManager;

public class CocoonStoreJanitor
extends StoreJanitorImpl
implements Serviceable,
Disposable {
    private String threadPool;
    private ServiceManager serviceManager;
    private RunnableManager runnableManager;
    private boolean m_firstRun = true;
    private boolean m_secondRun = false;

    public void parameterize(Parameters params) throws ParameterException {
        super.parameterize(params);
        this.threadPool = params.getParameter("thread-pool", "daemon");
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
        this.runnableManager = (RunnableManager)serviceManager.lookup(RunnableManager.ROLE);
    }

    public void dispose() {
        this.serviceManager.release((Object)this.runnableManager);
        this.runnableManager = null;
        this.serviceManager = null;
    }

    public void run() {
        if (this.m_firstRun || this.m_secondRun) {
            this.inUse = super.memoryInUse();
            this.m_secondRun = this.m_firstRun;
            this.m_firstRun = false;
        }
        super.checkMemory();
        this.relaunch(this.interval);
    }

    public void start() {
        this.relaunch(0L);
    }

    private void relaunch(long delay) {
        this.getLogger().debug("(Re-)Start CocoonStoreJanitor");
        this.runnableManager.execute(this.threadPool, this, delay, 0L);
    }
}

