/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.extended;

import net.sourceforge.chaperon.common.Decoder;
import net.sourceforge.chaperon.common.SortedCharSet;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.extended.CharacterInterval;
import net.sourceforge.chaperon.model.extended.Pattern;
import net.sourceforge.chaperon.model.extended.SingleCharacter;

public class CharacterClass
extends Pattern {
    private SingleCharacter[] characters = new SingleCharacter[0];
    private CharacterInterval[] intervals = new CharacterInterval[0];
    private boolean exclusive = false;

    public void addSingleCharacter(SingleCharacter character) {
        if (character == null) {
            return;
        }
        SingleCharacter[] newCharacters = new SingleCharacter[this.characters.length + 1];
        System.arraycopy(this.characters, 0, newCharacters, 0, this.characters.length);
        newCharacters[this.characters.length] = character;
        this.characters = newCharacters;
    }

    public SingleCharacter getSingleCharacter(int index) {
        return this.characters[index];
    }

    public SingleCharacter[] getSingleCharacters() {
        return this.characters;
    }

    public int getSingleCharacterCount() {
        return this.characters.length;
    }

    public void addCharacterInterval(CharacterInterval interval) {
        if (interval == null) {
            return;
        }
        CharacterInterval[] newIntervals = new CharacterInterval[this.intervals.length + 1];
        System.arraycopy(this.intervals, 0, newIntervals, 0, this.intervals.length);
        newIntervals[this.intervals.length] = interval;
        this.intervals = newIntervals;
    }

    public CharacterInterval getCharacterInterval(int index) {
        return this.intervals[index];
    }

    public CharacterInterval[] getCharacterIntervals() {
        return this.intervals;
    }

    public int getCharacterIntervalCount() {
        return this.intervals.length;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void update() {
        super.update();
        this.addFirstPattern(this);
        this.addLastPattern(this);
    }

    public char[] getLimits() {
        SortedCharSet limits = new SortedCharSet();
        int i = 0;
        while (i < this.characters.length) {
            limits.addChar(this.characters[i].getLimits());
            ++i;
        }
        int i2 = 0;
        while (i2 < this.intervals.length) {
            limits.addChar(this.intervals[i2].getLimits());
            ++i2;
        }
        return limits.getChar();
    }

    public boolean contains(char minimum, char maximum) {
        if (!this.exclusive) {
            int i = 0;
            while (i < this.characters.length) {
                if (this.characters[i].contains(minimum, maximum)) {
                    return true;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.intervals.length) {
                if (this.intervals[i2].contains(minimum, maximum)) {
                    return true;
                }
                ++i2;
            }
            return false;
        }
        int i = 0;
        while (i < this.characters.length) {
            if (this.characters[i].contains(minimum, maximum)) {
                return false;
            }
            ++i;
        }
        int i3 = 0;
        while (i3 < this.intervals.length) {
            if (this.intervals[i3].contains(minimum, maximum)) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    public boolean contains(char c) {
        if (!this.exclusive) {
            int i = 0;
            while (i < this.characters.length) {
                if (this.characters[i].contains(c)) {
                    return true;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.intervals.length) {
                if (this.intervals[i2].contains(c)) {
                    return true;
                }
                ++i2;
            }
            return false;
        }
        int i = 0;
        while (i < this.characters.length) {
            if (this.characters[i].contains(c)) {
                return false;
            }
            ++i;
        }
        int i3 = 0;
        while (i3 < this.intervals.length) {
            if (this.intervals[i3].contains(c)) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    public String getSymbol() {
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.exclusive) {
            buffer.append("^");
        }
        int i = 0;
        while (i < this.characters.length) {
            buffer.append(Decoder.decode(this.characters[i].getCharacter(), "[^- ]"));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.intervals.length) {
            buffer.append(Decoder.decode(this.intervals[i2].getFirstCharacter().getCharacter(), "[^- ]"));
            buffer.append("-");
            buffer.append(Decoder.decode(this.intervals[i2].getLastCharacter().getCharacter(), "[^- ]"));
            ++i2;
        }
        buffer.append("]");
        buffer.append("[");
        buffer.append(this.index);
        buffer.append("]");
        return buffer.toString();
    }

    public Object clone() {
        CharacterClass clone = new CharacterClass();
        int i = 0;
        while (i < this.characters.length) {
            clone.addSingleCharacter(this.characters[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.intervals.length) {
            clone.addCharacterInterval(this.intervals[i2]);
            ++i2;
        }
        clone.setExclusive(this.isExclusive());
        return clone;
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.characters.length + this.intervals.length == 0) {
            violations.addViolation("Character class is empty", this.getLocation());
        }
        int i = 0;
        while (i < this.characters.length) {
            violations.addViolations(this.characters[i].validate());
            ++i;
        }
        int i2 = 0;
        while (i2 < this.intervals.length) {
            violations.addViolations(this.intervals[i2].validate());
            ++i2;
        }
        return violations;
    }
}

