/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.constrained;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public class XmlTreeConstraint {
    private boolean debug = true;
    private Boolean isMyUriRequired;
    private List allowedMyUriStackEnd = null;
    private List allowedGlobalStackEnd = null;

    public XmlTreeConstraint(List allowedMyUriStackEnd, List allowedGlobalStackEnd, Boolean isMyUriRequired) {
        this.allowedMyUriStackEnd = allowedMyUriStackEnd;
        this.allowedGlobalStackEnd = allowedGlobalStackEnd;
        this.isMyUriRequired = isMyUriRequired;
    }

    public XmlTreeConstraint(List allowedMyUriStackEnd, Boolean isMyUriRequired) {
        this.allowedMyUriStackEnd = allowedMyUriStackEnd;
        this.isMyUriRequired = isMyUriRequired;
    }

    public XmlTreeConstraint(List allowedMyUriStackEnd) {
        this.allowedMyUriStackEnd = allowedMyUriStackEnd;
    }

    public XmlTreeConstraint(String[] allowedMyUriStackEnd, String[] allowedGlobalStackEnd, boolean isMyUriRequired) {
        this.allowedMyUriStackEnd = Arrays.asList(allowedMyUriStackEnd);
        this.allowedGlobalStackEnd = Arrays.asList(allowedGlobalStackEnd);
        this.isMyUriRequired = new Boolean(isMyUriRequired);
    }

    public XmlTreeConstraint(String[] allowedMyUriStackEnd, boolean isMyUriRequired) {
        this.allowedMyUriStackEnd = Arrays.asList(allowedMyUriStackEnd);
        this.isMyUriRequired = new Boolean(isMyUriRequired);
    }

    public XmlTreeConstraint(String[] allowedMyUriStackEnd) {
        this.allowedMyUriStackEnd = Arrays.asList(allowedMyUriStackEnd);
    }

    public boolean isAllowed(Boolean isMyUri, List myUriStack, List globalStack) {
        if (this.debug) {
            System.out.println("isMyUri :" + isMyUri + "\nrequired uri " + this.isMyUriRequired);
            System.out.println("myUristack: \n" + myUriStack);
            System.out.println("allowedMyUriStackEnd: \n" + this.allowedMyUriStackEnd);
            System.out.println("globalstack: \n" + globalStack);
            System.out.println("allowedGlobalStackEnd: \n" + this.allowedGlobalStackEnd);
        }
        if (this.isMyUriRequired != null) {
            if (isMyUri == null) {
                return false;
            }
            if (this.isMyUriRequired.booleanValue() && !isMyUri.booleanValue()) {
                return false;
            }
        }
        if (this.allowedMyUriStackEnd != null) {
            if (myUriStack == null) {
                return false;
            }
            if (!this.areEndsEqual(this.allowedMyUriStackEnd, myUriStack)) {
                return false;
            }
        }
        if (this.allowedGlobalStackEnd != null) {
            if (globalStack == null) {
                return false;
            }
            if (!this.areEndsEqual(this.allowedGlobalStackEnd, globalStack)) {
                return false;
            }
        }
        return true;
    }

    private boolean areEndsEqual(List l1, List l2) {
        if (l1.size() > l2.size()) {
            if (l1.size() != l2.size() && (l1.size() < 1 || l2.size() < 1)) {
                return false;
            }
            List l3 = l1;
            l1 = l2;
            l2 = l3;
        }
        ListIterator iter1 = l1.listIterator(l1.size());
        ListIterator iter2 = l2.listIterator(l2.size());
        while (iter1.hasPrevious()) {
            if (iter1.previous().toString().equals(iter2.previous().toString())) continue;
            return false;
        }
        return true;
    }
}

