/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.SAXBeanWriter;
import org.apache.commons.betwixt.strategy.ClassNormalizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogKitLogger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BetwixtTransformer
extends AbstractTransformer
implements Configurable {
    private static final String BETWIXT_NSURI = "http://apache.org/cocoon/betwixt/1.0";
    private static final String CMD_INCLUDE = "include";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SCOPE = "scope";
    private static final String SCOPE_SITEMAP = "sitemap";
    private static final String SCOPE_SESSION = "session";
    private static final String SCOPE_REQUEST = "request";
    private static final String SCOPE_CONTEXT = "context";
    private static final String ATTR_ELEMENT = "element";
    private static final String CONF_REFIDS = "ref-ids";
    private static XMLIntrospector introspector;
    private boolean refIds = true;
    private Map objectModel = null;
    private boolean inBetwixtElement = false;
    private SAXBeanWriter beanWriter = null;
    static /* synthetic */ Class class$org$apache$cocoon$transformation$BetwixtTransformer;

    public void configure(Configuration conf) throws ConfigurationException {
        String refIds = conf.getChild(CONF_REFIDS).getValue("true");
        this.refIds = "false".equals(refIds) || "no".equals(refIds);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) {
        this.objectModel = objectModel;
    }

    public void recycle() {
        this.objectModel = null;
        this.inBetwixtElement = false;
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (BETWIXT_NSURI.equals(uri)) {
            this.inBetwixtElement = false;
        } else {
            super.endElement(uri, name, raw);
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (BETWIXT_NSURI.equals(uri)) {
            this.inBetwixtElement = true;
            this.process(name, attr);
        } else {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        if (!this.inBetwixtElement) {
            super.characters(ch, start, len);
        }
    }

    private void process(String command, Attributes attr) throws SAXException {
        if (CMD_INCLUDE.equals(command)) {
            Context context;
            Session session;
            String scope = attr.getValue(ATTR_SCOPE);
            String name = attr.getValue(ATTR_NAME);
            if (name == null) {
                throw new SAXException("Required attribute name is missing on element include");
            }
            String element = attr.getValue(ATTR_ELEMENT);
            Object bean = null;
            if (scope == null || SCOPE_REQUEST.equals(scope)) {
                Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
                bean = request.getAttribute(name);
            }
            if ((scope == null && bean == null || SCOPE_SESSION.equals(scope)) && (session = ObjectModelHelper.getRequest((Map)this.objectModel).getSession(false)) != null) {
                bean = session.getAttribute(name);
            }
            if ((scope == null && bean == null || SCOPE_CONTEXT.equals(scope)) && (context = ObjectModelHelper.getContext((Map)this.objectModel)) != null) {
                bean = context.getAttribute(name);
            }
            if (scope == null && bean == null || SCOPE_SITEMAP.equals(scope)) {
                bean = this.objectModel.get(name);
            }
            if (bean != null) {
                this.includeBean(name, bean, element);
            } else {
                this.getLogger().warn("Bean " + name + " could not be found");
            }
        } else {
            throw new SAXException("Unknown command: " + command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeBean(String name, Object bean, String element) {
        try {
            if (this.beanWriter == null) {
                this.beanWriter = new SAXBeanWriter(this.contentHandler);
                this.beanWriter.setCallDocumentEvents(false);
                Class clazz = class$org$apache$cocoon$transformation$BetwixtTransformer == null ? (class$org$apache$cocoon$transformation$BetwixtTransformer = BetwixtTransformer.class$("org.apache.cocoon.transformation.BetwixtTransformer")) : class$org$apache$cocoon$transformation$BetwixtTransformer;
                synchronized (clazz) {
                    if (introspector == null) {
                        introspector = this.beanWriter.getXMLIntrospector();
                        introspector.setLog((Log)new LogKitLogger("betwixt"));
                        introspector.setClassNormalizer(new ClassNormalizer(){

                            public Class normalize(Class clazz) {
                                if (Proxy.isProxyClass(clazz) && clazz.getInterfaces().length > 0) {
                                    return clazz.getInterfaces()[0];
                                }
                                return super.normalize(clazz);
                            }
                        });
                    } else {
                        this.beanWriter.setXMLIntrospector(introspector);
                    }
                }
                this.beanWriter.getBindingConfiguration().setMapIDs(this.refIds);
            }
            if (bean instanceof Collection) {
                Iterator i = ((Collection)bean).iterator();
                while (i.hasNext()) {
                    if (element == null) {
                        this.beanWriter.write(bean);
                        continue;
                    }
                    this.beanWriter.write(element, bean);
                }
            } else if (element == null) {
                this.beanWriter.write(bean);
            } else {
                this.beanWriter.write(element, bean);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to marshal bean " + name, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

