/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.components.source.impl.ZipSourceFactory;
import org.apache.cocoon.util.MIMEUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;

public class ZipSource
extends AbstractLogEnabled
implements Source {
    Source archive;
    String documentName;

    public ZipSource(Source archive, String fileName) {
        this.archive = archive;
        this.documentName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        if (!this.archive.exists()) {
            return false;
        }
        ZipInputStream zipStream = null;
        ZipEntry document = null;
        boolean found = false;
        try {
            zipStream = new ZipInputStream(this.archive.getInputStream());
            do {
                if ((document = zipStream.getNextEntry()) == null) continue;
                if (document.getName().equals(this.documentName)) {
                    found = true;
                    continue;
                }
                zipStream.closeEntry();
            } while (document != null && !found);
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                zipStream.close();
            }
            catch (IOException ioe) {
                this.getLogger().error("Error while closing ZipInputStream: " + this.documentName);
            }
        }
        return found;
    }

    public InputStream getInputStream() throws IOException, SourceNotFoundException {
        ZipInputStream zipStream = new ZipInputStream(this.archive.getInputStream());
        ZipEntry document = null;
        boolean found = false;
        do {
            if ((document = zipStream.getNextEntry()) == null) continue;
            if (document.getName().equals(this.documentName)) {
                found = true;
                continue;
            }
            zipStream.closeEntry();
        } while (document != null && !found);
        if (document == null) {
            throw new SourceNotFoundException("The document " + this.documentName + " is not in the archive " + this.archive.getURI());
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int length = -1;
        while (zipStream.available() > 0) {
            length = zipStream.read(buffer, 0, 8192);
            if (length <= 0) continue;
            baos.write(buffer, 0, length);
        }
        zipStream.close();
        baos.flush();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public String getURI() {
        return this.archive.getURI() + "/" + this.documentName;
    }

    public String getScheme() {
        return ZipSourceFactory.ZIP_SOURCE_SCHEME;
    }

    public SourceValidity getValidity() {
        return this.archive.getValidity();
    }

    public void refresh() {
    }

    public String getMimeType() {
        String ext = this.documentName.substring(this.documentName.lastIndexOf("."));
        return MIMEUtils.getMIMEType((String)ext);
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return this.archive.getLastModified();
    }
}

