/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.source.impl.CachingSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.TraversableSource;

public class TraversableCachingSource
extends CachingSource
implements TraversableSource {
    private TraversableSource tsource;

    public TraversableCachingSource(String protocol, String location, TraversableSource source, Parameters params, int expires, boolean async) {
        super(protocol, location, (Source)source, params, expires, async);
        this.tsource = source;
    }

    public String getName() {
        try {
            this.initMetaResponse();
        }
        catch (IOException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failure initializing traversable response", (Throwable)e);
            }
            return null;
        }
        return ((CachingSource.TraversableSourceMeta)this.response.getExtra()).getName();
    }

    public boolean isCollection() {
        try {
            this.initMetaResponse();
        }
        catch (IOException e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failure initializing traversable response", (Throwable)e);
            }
            return false;
        }
        return ((CachingSource.TraversableSourceMeta)this.response.getExtra()).isCollection();
    }

    public Source getChild(String name) throws SourceException {
        Source child;
        try {
            this.initMetaResponse();
            child = this.tsource.getChild(name);
        }
        catch (SourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SourceException("Failure getting child", (Throwable)e);
        }
        if (!this.isCollection()) {
            throw new SourceException("Source is not a collection");
        }
        return this.createSource(this.getChildURI(this.uri, name), child);
    }

    public Collection getChildren() throws SourceException {
        try {
            this.initMetaResponse();
        }
        catch (SourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SourceException("Failure getting child", (Throwable)e);
        }
        if (!this.isCollection()) {
            throw new SourceException("Source is not a collection");
        }
        ArrayList<TraversableCachingSource> result = new ArrayList<TraversableCachingSource>();
        CachingSource.TraversableSourceMeta meta = (CachingSource.TraversableSourceMeta)this.response.getExtra();
        String[] children = meta.getChildren();
        int i = 0;
        while (i < children.length) {
            Source child;
            try {
                child = this.tsource.getChild(children[i]);
            }
            catch (IOException e) {
                throw new SourceException("Failure getting child", (Throwable)e);
            }
            result.add(this.createSource(this.getChildURI(this.uri, children[i]), child));
            ++i;
        }
        return result;
    }

    public Source getParent() throws SourceException {
        Source parent;
        try {
            this.initMetaResponse();
            parent = this.tsource.getParent();
        }
        catch (SourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SourceException("Failure getting parent", (Throwable)e);
        }
        return this.createSource(this.getParentURI(this.uri), parent);
    }

    private TraversableCachingSource createSource(String uri, Source wrapped) throws SourceException {
        TraversableCachingSource source = new TraversableCachingSource(this.protocol, uri, (TraversableSource)wrapped, new Parameters().merge(this.parameters), this.expires, this.async);
        source.cache = this.cache;
        source.resolver = this.resolver;
        source.refresher = this.refresher;
        ContainerUtil.enableLogging((Object)((Object)source), (Logger)this.getLogger());
        try {
            ContainerUtil.service((Object)((Object)source), (ServiceManager)this.manager);
            ContainerUtil.initialize((Object)((Object)source));
        }
        catch (Exception e) {
            throw new SourceException("Unable to initialize source.", (Throwable)e);
        }
        return source;
    }

    private String getChildURI(String parentURI, String childName) {
        String qs;
        String rest;
        int index = parentURI.indexOf(63);
        if (index != -1) {
            rest = parentURI.substring(0, index);
            qs = parentURI.substring(index);
        } else {
            rest = parentURI;
            qs = "";
        }
        String childURI = rest.charAt(rest.length() - 1) == '/' ? rest + childName : rest + "/" + childName;
        return childURI + qs;
    }

    private String getParentURI(String childURI) {
        String qs;
        String rest;
        int index = childURI.indexOf(63);
        if (index != -1) {
            rest = childURI.substring(0, index);
            qs = childURI.substring(index);
        } else {
            rest = childURI;
            qs = "";
        }
        index = rest.lastIndexOf(47, rest.length() - 2);
        String parentUri = index != -1 ? rest.substring(0, index) : rest;
        return parentUri + qs;
    }
}

