/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.rdbms;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class JDBC
extends AbstractSdxObject {
    protected String tableName = null;

    protected String getTableName() {
        return this.handleUnsupportedTokens(this.tableName);
    }

    protected abstract String getTableCreationQuery();

    protected void createTable(Connection conn) throws SDXException {
        try {
            Template template = new Template(conn, this.getTableCreationQuery());
            template.execute(new QueryExecutor(){}, 1);
        }
        catch (SDXException e) {
            String[] args = new String[]{this.getTableName(), e.getMessage()};
            throw new SDXException(super.getLog(), 3202, args, (Throwable)((Object)e));
        }
    }

    protected String handleUnsupportedTokens(String name) {
        return name.replace('-', '_');
    }

    protected void initVolatileObjectsToSax() {
    }

    public static class QueryExecutor {
        public void prepare(PreparedStatement ps) throws SQLException, SDXException {
        }

        public void collect(ResultSet rs) throws SQLException, IOException, SDXException {
        }

        public void collect(int value) throws SQLException {
        }

        public boolean exists() {
            return false;
        }

        public int value() {
            return -1;
        }

        public InputStream getInputStream() {
            return null;
        }

        public Object get() {
            return null;
        }
    }

    protected static class Template {
        public static final int MODE_NONE = -1;
        public static final int MODE_EXECUTE_QUERY = 0;
        public static final int MODE_EXECUTE_UPDATE = 1;
        protected Connection _conn;
        protected String _query;

        public Template(Connection conn, String query) {
            this._conn = conn;
            this._query = query;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(QueryExecutor qe, int mode) throws SDXException {
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = this._conn.prepareStatement(this._query);
                if (qe == null) {
                    return;
                }
                qe.prepare(ps);
                switch (mode) {
                    case 1: {
                        qe.collect(ps.executeUpdate());
                        return;
                    }
                    case 0: {
                        qe.collect(ps.executeQuery());
                        return;
                    }
                }
                return;
            }
            catch (SQLException e) {
                throw new SDXException(null, 4104, null, e);
            }
            catch (IOException e) {
                throw new SDXException(null, 4104, null, e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    throw new SDXException(null, 3200, null, e);
                }
                finally {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException e) {
                        throw new SDXException(null, 3203, null, e);
                    }
                }
            }
        }
    }
}

