/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.query.AbstractQuery;
import fr.gouv.culture.sdx.search.lucene.query.SDXTermQuery;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.TermInfo;
import fr.gouv.culture.sdx.search.lucene.query.Terms;
import fr.gouv.culture.sdx.search.lucene.queryparser.ParseException;
import fr.gouv.culture.sdx.search.lucene.queryparser.QueryParser;
import fr.gouv.culture.sdx.utils.Utilities;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FieldQuery
extends AbstractQuery {
    private Field field;

    public void setUp(SearchLocations sLocs, String q, String fieldName) throws SDXException {
        super.setSearchLocations(sLocs);
        if (q == null) {
            throw new SDXException(null, 4100, null, null);
        }
        this.field = this.searchLocations.getField(fieldName);
        if (this.field == null) {
            String[] args = new String[]{fieldName};
            throw new SDXException(super.getLog(), 4001, args, null);
        }
        this.queryText = q;
        switch (this.field.getFieldType()) {
            case 0: {
                try {
                    Analyzer analyzer = null;
                    QueryParser qp = this.searchLocations.getQueryParser();
                    String fName = this.field.getCode();
                    analyzer = this.field.getAnalyzer();
                    if (qp == null) {
                        throw new SDXException(super.getLog(), 4109, null, null);
                    }
                    if (analyzer == null) {
                        analyzer = this.searchLocations.getDefaultField().getAnalyzer();
                    }
                    if (fName != null && analyzer != null) {
                        qp.setUp(this.field.getCode(), analyzer);
                    }
                    this.luceneQuery = qp.parse(this.queryText);
                    break;
                }
                catch (ParseException e) {
                    String[] args = new String[]{q};
                    throw new SDXException(super.getLog(), 4101, args, e);
                }
            }
            case 2: {
                Date date = fr.gouv.culture.sdx.utils.Date.parseDate(q);
                if (date == null) {
                    this.luceneQuery = new TermQuery(new Term(this.field.getCode(), q));
                    break;
                }
                this.luceneQuery = new TermQuery(new Term(this.field.getCode(), DateField.dateToString(date)));
                break;
            }
            case 1: {
                if (this.queryText.indexOf("*") != -1 || this.queryText.indexOf("?") != -1) {
                    Terms terms = new Terms();
                    terms.enableLogging(super.getLog());
                    terms.setUp(this.searchLocations, this.field.getCode(), q);
                    TreeMap termList = terms.getList();
                    Iterator it = termList.values().iterator();
                    if (termList.size() < 1) {
                        this.luceneQuery = new SDXTermQuery(new Term(this.field.getCode(), this.queryText));
                        break;
                    }
                    this.luceneQuery = Utilities.newBooleanQuery();
                    while (it.hasNext()) {
                        ((BooleanQuery)this.luceneQuery).add((Query)new SDXTermQuery(((TermInfo)it.next()).getTerm()), false, false);
                    }
                    break;
                }
                this.luceneQuery = new SDXTermQuery(new Term(this.field.getCode(), this.queryText));
                break;
            }
            case 3: {
                String[] args = new String[]{fieldName};
                throw new SDXException(super.getLog(), 4001, args, null);
            }
        }
    }

    public void toSAX(ContentHandler hdl) throws SAXException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "query";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "type", "type", "CDATA", "field");
        atts = super.addAttributesLucene(atts);
        atts = super.addAttributesText(atts);
        atts.addAttribute("", "field", "field", "CDATA", this.field.getCode());
        hdl.startElement(sdxNsUri, localName, qName, atts);
        this.getSearchLocations().toSAX(hdl);
        if (this.filter != null) {
            this.filter.toSAX(hdl);
        }
        if (this.baseQuery != null) {
            String bqLocalName = "baseQuery";
            String bqQName = sdxNsPrefix + ":" + bqLocalName;
            AttributesImpl emptyAtts = new AttributesImpl();
            hdl.startElement(sdxNsUri, bqLocalName, bqQName, emptyAtts);
            this.baseQuery.toSAX(hdl);
            hdl.endElement(sdxNsUri, bqLocalName, bqQName);
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }
}

