/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.JDBCRepository;
import fr.gouv.culture.sdx.repository.JDBCRepositoryConnection;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.rdbms.JDBC;
import fr.gouv.culture.sdx.utils.rdbms.hsql.HSQLDB;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;

public class HSQLRepository
extends JDBCRepository {
    protected String dbDirPath = null;
    protected HSQLDB hsqldb = null;
    protected String DATABASE_DIR_NAME = "_hsql";

    public String getDatabaseDirectoryName() {
        return this.DATABASE_DIR_NAME;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        if (Utilities.checkString(this.dsi)) {
            return;
        }
        try {
            this.hsqldb = (HSQLDB)Utilities.getObjectFromContext("sdx.application.hsqldb", (Context)this.getContext());
            if (this.hsqldb == null) {
                throw new SDXException(super.getLog(), 305, null, null);
            }
            if (!Utilities.checkString(this.hsqldb.getDbDirPath())) {
                String basePath = Utilities.getStringFromContext("sdx.application.databaseDirPath", (Context)super.getContext());
                if (Utilities.checkString(basePath)) {
                    this.dbDirPath = basePath + this.getDatabaseDirectoryName() + File.separator;
                }
                if (Utilities.checkString(this.dbDirPath)) {
                    Utilities.checkDirectory(this.dbDirPath, super.getLog());
                    this.hsqldb.setDbDirPath(this.dbDirPath);
                }
            }
            this.tableName = super.getId();
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    protected String getTableCreationQuery() {
        return "CREATE CACHED TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + "data" + " BINARY, PRIMARY KEY (" + "id" + "))";
    }

    protected String getEntriesWithLimitQuery(long offset, long number) {
        String query = "SELECT LIMIT " + String.valueOf(offset) + " " + String.valueOf(number);
        query = query + " * FROM " + this.getTableName() + ";";
        return query;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws SDXException {
        JDBCRepositoryConnection jdbcConn;
        block11: {
            if (this.hsqldb != null) {
                this.hsqldb.registerTableName(this.getTableName());
            }
            Connection conn = null;
            ResultSet rs = null;
            jdbcConn = (JDBCRepositoryConnection)this.getConnection();
            try {
                conn = jdbcConn.getConnection();
                DatabaseMetaData dbmd = conn.getMetaData();
                rs = dbmd.getTables(null, null, this.getTableName().toUpperCase(), null);
                if (!rs.next()) {
                    this.createTable(conn);
                }
                if (rs == null) break block11;
            }
            catch (SQLException e) {
                try {
                    String[] args = new String[]{this.getId(), e.getMessage()};
                    throw new SDXException(super.getLog(), 3008, args, e);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {
                            String[] args = new String[]{this.getId(), e2.getMessage()};
                            throw new SDXException(super.getLog(), 3200, args, e2);
                        }
                    }
                    this.releaseConnection(jdbcConn);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(super.getLog(), 3200, args, e);
            }
        }
        this.releaseConnection(jdbcConn);
    }

    protected String getTableName() {
        return this.handleUnsupportedTokens(super.getTableName());
    }

    public RepositoryConnection getConnection() throws SDXException {
        if (Utilities.checkString(this.dsi)) {
            return super.getConnection();
        }
        try {
            JDBCRepositoryConnection conn = new JDBCRepositoryConnection(this.getSQLConnection());
            conn.enableLogging(super.getLog());
            return conn;
        }
        catch (SQLException e) {
            String[] args = new String[]{this.getId(), e.getMessage()};
            throw new SDXException(super.getLog(), 3007, args, e);
        }
    }

    private synchronized Connection getSQLConnection() throws SDXException {
        if (this.hsqldb == null) {
            throw new SDXException(super.getLog(), 305, null, null);
        }
        return this.hsqldb.getSQLConnection();
    }

    public void releaseConnection(RepositoryConnection conn) throws SDXException {
        if (Utilities.checkString(this.dsi)) {
            super.releaseConnection(conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void optimize() throws SDXException {
        JDBCRepositoryConnection jdbcConn = null;
        try {
            jdbcConn = new JDBCRepositoryConnection(this.getSQLConnection());
            Connection conn = jdbcConn.getConnection();
            String queryString = this.getOptimizeQuery();
            JDBC.Template template = new JDBC.Template(conn, queryString);
            template.execute(new JDBC.QueryExecutor(){}, 1);
        }
        catch (SDXException e) {
            try {
                String[] args = new String[]{super.getId()};
                throw new SDXException(super.getLog(), 314, args, (Throwable)((Object)e));
                catch (SQLException e2) {
                    args = new String[]{super.getId()};
                    throw new SDXException(super.getLog(), 314, args, e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseConnection(jdbcConn);
                throw throwable;
            }
        }
        this.releaseConnection(jdbcConn);
    }

    protected String getOptimizeQuery() {
        return "CHECKPOINT";
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        this._xmlizable_objects.put("Base_Directory", this.dbDirPath);
        return true;
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("type", "HSQL");
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
        super.restore(save_config);
    }
}

