<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsp="http://apache.org/xsp" 
	xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" 
	exclude-result-prefixes="xsl">
	
	
    <!--
    		<sdx:hilite>
    -->
    <xsl:template name="sdx:hilite">
    /* HILITE */
    sdx_pipeline=null; <xsl:call-template name="sdx:parameter">
            <xsl:with-param name="name" select="'hilite'"/>
        </xsl:call-template> 
    if (sdx_bool)
    { 
        if (sdx_query != null) {}/*a query from the same xsp page*/
         /* try to get cached results based on user param */
        <xsl:call-template name="sdx:parameter">
            <xsl:with-param name="name" select="'qid'"/>
        </xsl:call-template> 
        sdx_object=getSessionObject(session, sdx_parameter);
        if (sdx_object != null)
        {
            if (sdx_object instanceof Results) sdx_results=(Results)sdx_object;
            if (sdx_object instanceof Terms) sdx_terms=(Terms)sdx_object;
        }
        /*results from a query in the same page or cached results*/
        if (sdx_results != null) sdx_query = sdx_results.getQuery();
        if (sdx_query != null || sdx_terms != null)
        {
            sdx_pipeline = new LuceneTermHighlighter();
            ((LuceneTermHighlighter)sdx_pipeline).enableLogging(sdx_log);
        if (sdx_query != null)
            ((LuceneTermHighlighter)sdx_pipeline).setQuery(sdx_query);
        else if (sdx_terms != null)/*terms from same page or cached*/
            ((LuceneTermHighlighter)sdx_pipeline).setTerms(sdx_terms);
            ((LuceneTermHighlighter)sdx_pipeline).setConsumer(sdx_consumer); /* change consumer */
        }

           <xsl:if test="ancestor::sdx:debug">
	           <sdx:debug title="PIPELINE hilite">
     	          <xsp:attribute name="qid">
                    	<xsp:expr>sdx_parameter</xsp:expr>
              	 	</xsp:attribute>
	               <xsp:attribute name="query">
     	              <xsp:expr>sdx_query</xsp:expr>
                	</xsp:attribute>
                    <xsp:attribute name="terms">
     	              <xsp:expr>sdx_terms</xsp:expr>
                	</xsp:attribute>
              	 	<xsp:attribute name="element">
               	    	<xsl:value-of select="name()"/>
	               </xsp:attribute>
			</sdx:debug>
		</xsl:if>
    }
    </xsl:template>
    
    
    <!--
    		<sdx:pipeline>
    
		Build a pipeline.
	-->
    <xsl:template match="sdx:pipeline" name="sdx:pipeline">
        <xsp:logic>
            <xsl:call-template name="comment"/>
     sdx_pipeline=null;
     sdx_xml="";
     sdx_xml+="<xsl:apply-templates select="." mode="conf"/>";
     sdx_conf=new DefaultConfigurationBuilder(true).build(new ByteArrayInputStream(sdx_xml.getBytes("UTF-8")));
     sdx_pipeline=new GenericPipeline();
     sdx_pipeline.enableLogging(sdx_log);
     sdx_pipeline.contextualize(Utilities.createNewReadOnlyContext(this.avalonContext));
     sdx_pipeline.service(cocoon_serviceManager);
     sdx_pipeline.configure(sdx_conf);

            <xsl:if test="ancestor::sdx:debug">
                <sdx:debug title="PIPELINE indexation">
                    <xsp:attribute name="xml">
                        <xsp:expr>sdx_xml</xsp:expr>
                    </xsp:attribute>
                    <xsp:attribute name="element">
                        <xsl:value-of select="name()"/>
                    </xsp:attribute>
                    <xsp:expr>sdx_pipeline</xsp:expr>
                </sdx:debug>
            </xsl:if>
            
     sdx_xml=null;
        </xsp:logic>
    </xsl:template>
    
    
    <!--
		Mode conf : write a string for building a Configuration object.
	-->
    <xsl:template name="el" match="*" mode="conf">
        <xsl:param name="root" select="true()"/>
        <xsl:text>&lt;</xsl:text>
        <xsl:value-of select="name()"/>
        <xsl:apply-templates select="@*" mode="conf"/>
        <!-- xmlns -->
        <xsl:call-template name="xmlns">
            <xsl:with-param name="root" select="$root"/>
        </xsl:call-template>
        <xsl:text>&gt;</xsl:text>
        <xsl:apply-templates select="*" mode="conf">
            <xsl:with-param name="root"/>
        </xsl:apply-templates>
        <!-- close element -->
        <xsl:text>&lt;/</xsl:text>
        <xsl:value-of select="name()"/>
        <xsl:text>&gt;</xsl:text>
    </xsl:template>
    
    
    <!--
    		Handle transformation element to set @src.
    	-->
    <xsl:template match="sdx:transformation[@*[contains(name(), 'src')]]" mode="conf">
        <xsl:text>&lt;sdx:transformation</xsl:text>
        <!-- adding attributes except src(s) -->
        <xsl:apply-templates select="@*[not(contains(name(), 'src'))]" mode="conf"/>
        <!-- closing string to add src attribute -->
        <xsl:text>"; </xsl:text>
        <!-- get sdx_parameter value -->
        <xsl:call-template name="sdx:parameter">
            <xsl:with-param name="name" select="'src'"/>
            <xsl:with-param name="http"/>
        </xsl:call-template>
        <xsl:text>
        sdx_object=Utilities.resolveFile(sdx_log, context_realPath, null, sdx_parameter, false);
        if (sdx_object != null) sdx_parameter=((File)sdx_object).toURL().toExternalForm();
        sdx_xml+=" src='" + sdx_parameter + "'/&gt;</xsl:text>
    </xsl:template>
    
    
    <!--
    		Handle parameter element to set @value.
    	-->
    <xsl:template match="sdx:parameter[@*[contains(name(), 'value')]]" mode="conf">
        <xsl:text>&lt;sdx:parameter</xsl:text>
        <!-- adding attributes except value(s) -->
        <xsl:apply-templates select="@*[not(contains(name(), 'value'))]" mode="conf"/>
        <!-- closing string to add value attribute -->
        <xsl:text>"; </xsl:text>
        <!-- get sdx_parameter value -->
        <xsl:call-template name="sdx:parameter">
            <xsl:with-param name="name" select="'value'"/>
            <xsl:with-param name="http"/>
        </xsl:call-template>
        <xsl:text>sdx_xml+=" value='" + sdx_parameter + "'/&gt; </xsl:text>
    </xsl:template>
    
    <xsl:template match="xsp:text" mode="conf"/>
    
    <xsl:template name="att" match="@*" mode="conf">
        <xsl:param name="name">
            <xsl:value-of select="name()"/>
        </xsl:param>
        <xsl:param name="value">
            <xsl:apply-templates select="." mode="escapeQuot">
                <xsl:with-param name="quot">'</xsl:with-param>
            </xsl:apply-templates>
        </xsl:param>
        <xsl:text>&#32;</xsl:text>
        <xsl:value-of select="$name"/>
        <xsl:text>='</xsl:text>
        <xsl:value-of select="$value"/>
        <xsl:text>'</xsl:text>
    </xsl:template>
    
    
    <!--
    		xmlns attributes.
    	-->
    <xsl:template name="xmlns">
        <xsl:param name="root"/>
        <xsl:variable name="ns" select="../namespace::*"/>

        <xsl:for-each select="namespace::*">

            <!-- dont't display ns herited, except when node is given as a new root -->
            <xsl:if test="
            name() != 'xml' 
            and (
                not(. = $ns) 
                or not($ns[name()=name(current())])
                or $root
            )">
                <xsl:call-template name="att">
                    <xsl:with-param name="name">
                        <xsl:text>xmlns</xsl:text>
                        <xsl:if test="normalize-space(name())!=''">
                            <xsl:text>:</xsl:text>
                            <xsl:value-of select="name()"/>
                        </xsl:if>
                    </xsl:with-param>
                    <xsl:with-param name="value" select="."/>
                </xsl:call-template>
            </xsl:if>
        </xsl:for-each>

    </xsl:template>

</xsl:stylesheet>
