/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 8 oct. 2002
 * Time: 13:19:53
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.sdx.utils.Utilities;

public class SimpleIDGenerator extends AbstractIDGenerator {

    long currentId = 0;

    /**Generates an idea appending the given strings
     * to an incremented long class field beginning from
     * zero.
     *
     * @param prefix    The prefix for the generated id
     * @param suffix    The suffix for the generated id
     * */
    public String generate(String prefix, String suffix) {
        String id = "";

        id = String.valueOf(currentId);
        currentId++;

        if (Utilities.checkString(prefix))
            id = prefix + id;

        if (Utilities.checkString(suffix))
            id = id + suffix;

        if (!isIdUnique(id))
            return generate(prefix, suffix); //a recursive call will loop until a unique id is generated

        return id;
    }

}
