/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.grammar;

import java.util.Hashtable;
import java.util.Stack;
import net.sourceforge.chaperon.model.grammar.Associativity;
import net.sourceforge.chaperon.model.grammar.Error;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.grammar.Production;
import net.sourceforge.chaperon.model.symbol.Nonterminal;
import net.sourceforge.chaperon.model.symbol.Symbol;
import net.sourceforge.chaperon.model.symbol.Terminal;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GrammarFactory
extends DefaultHandler {
    public static final String NS = "http://chaperon.sourceforge.net/schema/grammar/1.0";
    public static final String GRAMMAR_ELEMENT = "grammar";
    public static final String PRODUCTION_ELEMENT = "production";
    public static final String PRECEDENCE_ATTRIBUTE = "precedence";
    public static final String NONTERMINALSYMBOL_ELEMENT = "nonterminal";
    public static final String TERMINALSYMBOL_ELEMENT = "terminal";
    public static final String ERRORSYMBOL_ELEMENT = "error";
    public static final String STARTSYMBOL_ELEMENT = "start";
    public static final String PRIORITY_ELEMENT = "priority";
    public static final String ASSOCIATIVITY_ELEMENT = "associativity";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String SYMBOL_ATTRIBUTE = "symbol";
    private static final int STATE_OUTER = 0;
    private static final int STATE_GRAMMAR = 1;
    private static final int STATE_PRODUCTION = 2;
    private static final int STATE_START = 3;
    private static final int STATE_NONTERMINAL = 4;
    private static final int STATE_TERMINAL = 5;
    private static final int STATE_ASSOCIATIVITY = 6;
    private static final int STATE_PRIORITY = 7;
    private static final int STATE_PRIORITYTERMINAL = 8;
    private static final int STATE_ERROR = 9;
    private int state = 0;
    private Grammar grammar;
    private Hashtable terminals = new Hashtable();
    private Hashtable nonterminals = new Hashtable();
    private Stack stack;
    private Locator locator = null;
    private int priorities = 0;

    public Grammar getGrammar() {
        return this.grammar;
    }

    private String getLocation() {
        if (this.locator == null) {
            return "unknown";
        }
        return this.locator.getSystemId() + ":" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() {
        this.stack = new Stack();
        this.state = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!namespaceURI.equals(NS)) throw new SAXException("Unexpected element " + qName + " at " + this.getLocation());
        if (localName.equals(GRAMMAR_ELEMENT) && this.state == 0) {
            this.grammar = new Grammar();
            this.grammar.setLocation(this.getLocation());
            this.stack.push(this.grammar);
            this.state = 1;
            return;
        } else if (localName.equals(PRODUCTION_ELEMENT) && this.state == 1) {
            Production production = new Production(this.getNonterminal(this.nonterminals, atts.getValue(SYMBOL_ATTRIBUTE)));
            production.setLocation(this.getLocation());
            String precedencesymbol = atts.getValue(PRECEDENCE_ATTRIBUTE);
            if (precedencesymbol != null && precedencesymbol.length() > 0) {
                production.setPrecedence(new Terminal(precedencesymbol));
            }
            this.stack.push(production);
            this.state = 2;
            return;
        } else if (localName.equals(NONTERMINALSYMBOL_ELEMENT) && this.state == 2) {
            this.stack.push(this.getNonterminal(this.nonterminals, atts.getValue(SYMBOL_ATTRIBUTE)));
            this.state = 4;
            return;
        } else if (localName.equals(TERMINALSYMBOL_ELEMENT) && this.state == 2) {
            this.stack.push(new Terminal(atts.getValue(SYMBOL_ATTRIBUTE)));
            this.state = 5;
            return;
        } else if (localName.equals(ERRORSYMBOL_ELEMENT) && this.state == 2) {
            this.stack.push(new Error());
            this.state = 9;
            return;
        } else if (localName.equals(STARTSYMBOL_ELEMENT) && this.state == 1) {
            this.stack.push(new Nonterminal(atts.getValue(SYMBOL_ATTRIBUTE)));
            this.state = 3;
            return;
        } else if (localName.equals(ASSOCIATIVITY_ELEMENT) && this.state == 1) {
            this.grammar.setAssociativity(this.getTerminal(this.terminals, atts.getValue(SYMBOL_ATTRIBUTE)), new Associativity(atts.getValue(TYPE_ATTRIBUTE)));
            this.state = 6;
            return;
        } else if (localName.equals(PRIORITY_ELEMENT) && this.state == 1) {
            this.priorities = 0;
            this.state = 7;
            return;
        } else {
            if (!localName.equals(TERMINALSYMBOL_ELEMENT) || this.state != 7) throw new SAXException("Unexpected element " + qName + " at " + this.getLocation());
            this.stack.push(this.getTerminal(this.terminals, atts.getValue(SYMBOL_ATTRIBUTE)));
            ++this.priorities;
            this.state = 8;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!namespaceURI.equals(NS)) throw new SAXException("Unexpected element " + qName + " at " + this.getLocation());
        if (localName.equals(GRAMMAR_ELEMENT) && this.state == 1) {
            this.grammar = (Grammar)this.stack.pop();
            this.state = 0;
            return;
        } else if (localName.equals(PRODUCTION_ELEMENT) && this.state == 2) {
            Production production = (Production)this.stack.pop();
            Grammar grammar = (Grammar)this.stack.peek();
            grammar.addProduction(production);
            this.state = 1;
            return;
        } else if (localName.equals(NONTERMINALSYMBOL_ELEMENT) && this.state == 4) {
            Symbol ntsymbol = (Symbol)this.stack.pop();
            Production production = (Production)this.stack.peek();
            production.getDefinition().addSymbol(ntsymbol);
            this.state = 2;
            return;
        } else if (localName.equals(TERMINALSYMBOL_ELEMENT) && this.state == 5) {
            Symbol tsymbol = (Symbol)this.stack.pop();
            Production production = (Production)this.stack.peek();
            production.getDefinition().addSymbol(tsymbol);
            this.state = 2;
            return;
        } else if (localName.equals(ERRORSYMBOL_ELEMENT) && this.state == 9) {
            Symbol error = (Symbol)this.stack.pop();
            Production production = (Production)this.stack.peek();
            production.getDefinition().addSymbol(error);
            this.state = 2;
            return;
        } else if (localName.equals(STARTSYMBOL_ELEMENT) && this.state == 3) {
            Nonterminal ssymbol = (Nonterminal)this.stack.pop();
            Grammar grammar = (Grammar)this.stack.peek();
            grammar.setStartSymbol(ssymbol);
            this.state = 1;
            return;
        } else if (localName.equals(ASSOCIATIVITY_ELEMENT) && this.state == 6) {
            this.state = 1;
            return;
        } else if (localName.equals(PRIORITY_ELEMENT) && this.state == 7) {
            int i = 0;
            while (this.stack.peek() instanceof Terminal) {
                this.grammar.setPriority((Terminal)this.stack.pop(), i + 1);
                ++i;
            }
            this.state = 1;
            return;
        } else {
            if (!localName.equals(TERMINALSYMBOL_ELEMENT) || this.state != 8) throw new SAXException("Unexpected element " + qName + " at " + this.getLocation());
            this.state = 7;
        }
    }

    private Terminal getTerminal(Hashtable terminals, String name) {
        Terminal terminal = (Terminal)terminals.get(name);
        if (terminal == null) {
            terminal = new Terminal(name);
            terminals.put(name, terminal);
        }
        return terminal;
    }

    private Nonterminal getNonterminal(Hashtable nonterminals, String name) {
        Nonterminal nonterminal = (Nonterminal)nonterminals.get(name);
        if (nonterminal == null) {
            nonterminal = new Nonterminal(name);
            nonterminals.put(name, nonterminal);
        }
        return nonterminal;
    }
}

