/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.helpers;

import java.io.IOException;
import java.io.Serializable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.transformation.helpers.IncludeCacheStorageProxy;
import org.apache.excalibur.store.Store;

public final class StoreIncludeCacheStorageProxy
implements IncludeCacheStorageProxy {
    private Store store;
    private Logger logger;

    public StoreIncludeCacheStorageProxy(Store store, Logger logger) {
        this.store = store;
        this.logger = logger;
    }

    private String getKey(String uri) {
        return "DCS:" + uri;
    }

    public Serializable get(String uri) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("StoreProxy: Getting content for " + uri);
        }
        Serializable result = (Serializable)this.store.get((Object)this.getKey(uri));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("StoreProxy: Result for " + uri + " : " + (result == null ? "Not in cache" : "Found"));
        }
        return result;
    }

    public void put(String uri, Serializable object) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("StoreProxy: Storing content for " + uri);
        }
        this.store.store((Object)this.getKey(uri), (Object)object);
    }

    public void remove(String uri) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("StoreProxy: Removing content for " + uri);
        }
        this.store.remove((Object)this.getKey(uri));
    }
}

