/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.caching;

import java.io.Serializable;

public final class ComponentCacheKey
implements Serializable {
    public static final int ComponentType_Generator = 1;
    public static final int ComponentType_Transformer = 3;
    public static final int ComponentType_Serializer = 5;
    public static final int ComponentType_Reader = 7;
    private static final String[] COMPONENTS = new String[]{"X", "G", "X", "T", "X", "S", "X", "R"};
    private final int type;
    private final String identifier;
    private final Serializable key;
    private final int hashCode;
    private final boolean cachePoint;
    private String toString;

    public ComponentCacheKey(int componentType, String componentIdentifier, Serializable cacheKey) {
        this(componentType, componentIdentifier, cacheKey, false);
    }

    public ComponentCacheKey(int componentType, String componentIdentifier, Serializable cacheKey, boolean cachePoint) {
        this.type = componentType;
        this.identifier = componentIdentifier;
        this.key = cacheKey;
        this.cachePoint = cachePoint;
        this.hashCode = this.type + (this.identifier.length() << 3) + this.key.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ComponentCacheKey) {
            ComponentCacheKey ccp = (ComponentCacheKey)object;
            if (this.type == ccp.type && this.identifier.equals(ccp.identifier) && this.key.equals(ccp.key)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = COMPONENTS[this.type] + '-' + this.identifier + '-' + this.key.toString();
        }
        return this.toString;
    }

    public boolean isCachePoint() {
        return this.cachePoint;
    }
}

