/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

public class XSLTExtension {
    public static String escapeJavaString(String string) {
        char[] chr = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < chr.length) {
            char c = chr[i];
            switch (c) {
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\"': 
                case '\\': {
                    buffer.append('\\');
                    buffer.append(c);
                    break;
                }
                default: {
                    if (' ' <= c && c <= '\u007f') {
                        buffer.append(c);
                        break;
                    }
                    buffer.append("\\u");
                    buffer.append(XSLTExtension.int2digit(c >> 12));
                    buffer.append(XSLTExtension.int2digit(c >> 8));
                    buffer.append(XSLTExtension.int2digit(c >> 4));
                    buffer.append(XSLTExtension.int2digit(c));
                }
            }
            ++i;
        }
        String encoded = buffer.toString();
        return encoded;
    }

    public static String escapeString(String string) {
        char[] chr = string.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < chr.length) {
            char c = chr[i];
            if (c <= '\u007f') {
                buffer.append(c);
            } else {
                buffer.append("\\u");
                buffer.append(XSLTExtension.int2digit(c >> 12));
                buffer.append(XSLTExtension.int2digit(c >> 8));
                buffer.append(XSLTExtension.int2digit(c >> 4));
                buffer.append(XSLTExtension.int2digit(c));
            }
            ++i;
        }
        String encoded = buffer.toString();
        return encoded;
    }

    private static char int2digit(int x) {
        if ((x &= 0xF) <= 9) {
            return (char)(x + 48);
        }
        return (char)(x - 10 + 65);
    }

    public String escape(String string) {
        return XSLTExtension.escapeString(string);
    }

    public String escapeJava(String string) {
        return XSLTExtension.escapeJavaString(string);
    }

    public String prefix(String string) {
        char[] chr = string.toCharArray();
        int i = 0;
        while (i < chr.length) {
            if (chr[i] == '\n' || chr[i] == '\r') break;
            ++i;
        }
        if (i == chr.length) {
            return "";
        }
        int j = 0;
        while (i < chr.length) {
            if (chr[i] == '\n' || chr[i] == '\r') {
                j = 0;
            } else {
                if (!Character.isSpaceChar(chr[i])) break;
                ++j;
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        i = 0;
        while (i < j) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    public String suffix(String string) {
        char[] chr = string.toCharArray();
        int j = 0;
        int i = chr.length - 1;
        while (i >= 0) {
            if (chr[i] == '\n' || chr[i] == '\r') break;
            if (!Character.isSpaceChar(chr[i])) {
                return "";
            }
            ++j;
            --i;
        }
        StringBuffer buffer = new StringBuffer();
        int i2 = 0;
        while (i2 < j) {
            buffer.append(' ');
            ++i2;
        }
        return buffer.toString();
    }
}

