/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.transformation;

import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.xml.sax.SAXException;

public abstract class AbstractCopletTransformer
extends AbstractSAXTransformer {
    public static final String COPLET_ID_PARAM = "copletId";
    public static final String PORTAL_NAME_PARAM = "portalName";
    private PortalService _portalService;

    protected CopletInstanceData getCopletInstanceData() throws SAXException {
        CopletInstanceData cid = this.getCopletInstanceData(null);
        if (cid == null) {
            throw new SAXException("Could not find coplet instance data for the current pipeline.");
        }
        return cid;
    }

    protected PortalService getPortalService() throws SAXException {
        if (this._portalService == null) {
            try {
                this._portalService = (PortalService)this.manager.lookup(PortalService.ROLE);
                if (this._portalService.getPortalName() == null) {
                    Map context;
                    String portalName = this.parameters.getParameter(PORTAL_NAME_PARAM, (String)this.objectModel.get("cocoon-portal-portalName"));
                    if (portalName == null && (context = (Map)this.objectModel.get("parent-context")) != null) {
                        portalName = (String)context.get("cocoon-portal-portalName");
                    }
                    if (portalName == null) {
                        throw new SAXException("portalName must be passed as parameter or in the object model.");
                    }
                    this._portalService.setPortalName(portalName);
                }
            }
            catch (ServiceException se) {
                throw new SAXException("Unable to get portal service.", (Exception)((Object)se));
            }
        }
        return this._portalService;
    }

    protected CopletInstanceData getCopletInstanceData(String copletId) throws SAXException {
        Map context = (Map)this.objectModel.get("parent-context");
        if (copletId == null) {
            if (context != null) {
                copletId = (String)context.get("cocoon-portal-copletId");
            } else {
                try {
                    copletId = this.parameters.getParameter(COPLET_ID_PARAM);
                }
                catch (ParameterException e) {
                    throw new SAXException("copletId must be passed as parameter or in the object model within the parent context.");
                }
            }
        }
        if (copletId == null) {
            throw new SAXException("copletId must be passed as parameter or in the object model within the parent context.");
        }
        CopletInstanceData object = this.getPortalService().getComponentManager().getProfileManager().getCopletInstanceData(copletId);
        return object;
    }

    public void recycle() {
        if (this._portalService != null) {
            this.manager.release((Object)this._portalService);
            this._portalService = null;
        }
        super.recycle();
    }
}

