/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.impl;

import java.util.Iterator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.renderer.Renderer;
import org.apache.cocoon.portal.layout.renderer.aspect.RendererAspect;
import org.apache.cocoon.portal.layout.renderer.aspect.impl.DefaultRendererContext;
import org.apache.cocoon.portal.layout.renderer.aspect.impl.RendererAspectChain;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AspectRenderer
extends AbstractLogEnabled
implements Renderer,
Serviceable,
Configurable,
Disposable,
ThreadSafe,
Contextualizable {
    protected ServiceManager manager;
    protected RendererAspectChain chain;
    protected ServiceSelector aspectSelector;
    protected Context context;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.aspectSelector = (ServiceSelector)this.manager.lookup(RendererAspect.ROLE + "Selector");
    }

    public void toSAX(Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        DefaultRendererContext renderContext = new DefaultRendererContext(this.chain);
        renderContext.setObjectModel(ContextHelper.getObjectModel((Context)this.context));
        renderContext.invokeNext(layout, service, handler);
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.chain = new RendererAspectChain();
        this.chain.configure(this.aspectSelector, conf.getChild("aspects"));
    }

    public void dispose() {
        if (this.manager != null) {
            if (this.chain != null) {
                this.chain.dispose(this.aspectSelector);
            }
            this.manager.release((Object)this.aspectSelector);
            this.aspectSelector = null;
            this.manager = null;
        }
    }

    public Iterator getAspectDescriptions() {
        return this.chain.getAspectDescriptionIterator();
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }
}

