/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.layout.renderer.impl;

import java.util.Collections;
import java.util.Iterator;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.layout.Layout;
import org.apache.cocoon.portal.layout.renderer.Renderer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public abstract class AbstractRenderer
extends AbstractLogEnabled
implements Renderer,
Serviceable,
Disposable,
ThreadSafe {
    protected ServiceSelector rendererSelector;
    protected ServiceManager manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public String getStylesheetURI(Layout layout) {
        return null;
    }

    public boolean useStylesheet() {
        return false;
    }

    public void dispose() {
        if (null != this.manager) {
            this.manager.release((Object)this.rendererSelector);
            this.manager = null;
            this.rendererSelector = null;
        }
    }

    public void toSAX(Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        block8: {
            block7: {
                XSLTProcessor processor;
                block6: {
                    if (!this.useStylesheet()) break block7;
                    processor = null;
                    Source stylesheet = null;
                    SourceResolver resolver = null;
                    try {
                        resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                        stylesheet = resolver.resolveURI(this.getStylesheetURI(layout));
                        processor = (XSLTProcessor)this.manager.lookup(XSLTProcessor.ROLE);
                        TransformerHandler transformer = processor.getTransformerHandler(stylesheet);
                        SAXResult result = new SAXResult((ContentHandler)new IncludeXMLConsumer(handler));
                        if (handler instanceof LexicalHandler) {
                            result.setLexicalHandler((LexicalHandler)((Object)handler));
                        }
                        transformer.setResult(result);
                        transformer.startDocument();
                        this.process(layout, service, transformer);
                        transformer.endDocument();
                        if (null == resolver) break block6;
                    }
                    catch (Exception ce) {
                        try {
                            throw new SAXException("Unable to lookup component.", ce);
                        }
                        catch (Throwable throwable) {
                            if (null != resolver) {
                                resolver.release(stylesheet);
                                this.manager.release((Object)resolver);
                            }
                            this.manager.release(processor);
                            throw throwable;
                        }
                    }
                    resolver.release(stylesheet);
                    this.manager.release((Object)resolver);
                }
                this.manager.release((Object)processor);
                break block8;
            }
            this.process(layout, service, handler);
        }
    }

    protected void processLayout(Layout layout, PortalService service, ContentHandler handler) throws SAXException {
        String rendererName = layout.getRendererName();
        Renderer renderer = null;
        renderer = service.getComponentManager().getRenderer(rendererName);
        renderer.toSAX(layout, service, handler);
    }

    protected abstract void process(Layout var1, PortalService var2, ContentHandler var3) throws SAXException;

    public Iterator getAspectDescriptions() {
        return Collections.EMPTY_LIST.iterator();
    }
}

