/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.event.behavior.IElementEventHandler;

public class ElementAttributes
implements IElementAttributes,
Serializable,
Cloneable {
    public boolean IS_DISTRIBUTE = false;
    public boolean IS_SPOOL = false;
    public boolean IS_LATERAL = false;
    public boolean IS_REMOTE = false;
    public boolean IS_ETERNAL = true;
    public long version = 0L;
    public long mls = -1L;
    public long idle = -1L;
    public int size = 0;
    public long createTime = 0L;
    public long lastAccessTime = 0L;
    public ArrayList eventHandlers;

    public ElementAttributes() {
        this.lastAccessTime = this.createTime = System.currentTimeMillis();
    }

    private ElementAttributes(ElementAttributes attr) {
        this.IS_ETERNAL = attr.IS_ETERNAL;
        this.IS_SPOOL = attr.IS_SPOOL;
        this.IS_DISTRIBUTE = attr.IS_DISTRIBUTE;
        this.IS_LATERAL = attr.IS_LATERAL;
        this.IS_REMOTE = attr.IS_REMOTE;
        this.mls = attr.mls;
        this.idle = attr.idle;
        this.size = attr.size;
    }

    public IElementAttributes copy() {
        try {
            ElementAttributes attr = new ElementAttributes();
            attr.setIdleTime(this.getIdleTime());
            attr.setIsEternal(this.getIsEternal());
            attr.setIsDistribute(this.getIsDistribute());
            attr.setIsLateral(this.getIsLateral());
            attr.setIsRemote(this.getIsRemote());
            attr.setIsSpool(this.getIsSpool());
            attr.setMaxLifeSeconds(this.getMaxLifeSeconds());
            attr.addElementEventHandlers(this.eventHandlers);
            return attr;
        }
        catch (Exception e) {
            return new ElementAttributes();
        }
    }

    public Object clone2() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            byte[] buf = baos.toByteArray();
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bais);
            ElementAttributes attr = (ElementAttributes)ois.readObject();
            ois.close();
            attr.createTime = System.currentTimeMillis();
            return attr;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setMaxLifeSeconds(long mls) {
        this.mls = mls;
    }

    public long getMaxLifeSeconds() {
        return this.mls;
    }

    public void setIdleTime(long idle) {
        this.idle = idle;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime() {
        this.createTime = System.currentTimeMillis();
    }

    public long getVersion() {
        return this.version;
    }

    public long getIdleTime() {
        return this.idle;
    }

    public long getTimeToLiveSeconds() {
        long now = System.currentTimeMillis();
        return this.getCreateTime() + this.getMaxLifeSeconds() * 1000L - now;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTimeNow() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean getIsDistribute() {
        return this.IS_DISTRIBUTE;
    }

    public void setIsDistribute(boolean val) {
        this.IS_DISTRIBUTE = val;
    }

    public boolean getIsSpool() {
        return this.IS_SPOOL;
    }

    public void setIsSpool(boolean val) {
        this.IS_SPOOL = val;
    }

    public boolean getIsLateral() {
        return this.IS_LATERAL;
    }

    public void setIsLateral(boolean val) {
        this.IS_LATERAL = val;
    }

    public boolean getIsRemote() {
        return this.IS_REMOTE;
    }

    public void setIsRemote(boolean val) {
        this.IS_REMOTE = val;
    }

    public boolean getIsEternal() {
        return this.IS_ETERNAL;
    }

    public void setIsEternal(boolean val) {
        this.IS_ETERNAL = val;
    }

    public void addElementEventHandler(IElementEventHandler eventHandler) {
        if (this.eventHandlers == null) {
            this.eventHandlers = new ArrayList();
        }
        this.eventHandlers.add(eventHandler);
    }

    public void addElementEventHandlers(ArrayList eventHandlers) {
        if (eventHandlers == null) {
            return;
        }
        Iterator iter = ((AbstractList)eventHandlers).iterator();
        while (iter.hasNext()) {
            this.addElementEventHandler((IElementEventHandler)iter.next());
        }
    }

    public ArrayList getElementEventHandlers() {
        return this.eventHandlers;
    }

    public String toString() {
        StringBuffer dump = new StringBuffer();
        dump.append("[ IS_LATERAL = ").append(this.IS_LATERAL).append(", IS_SPOOL = ").append(this.IS_SPOOL).append(", IS_REMOTE = ").append(this.IS_REMOTE).append(", IS_ETERNAL = ").append(this.IS_ETERNAL).append(", MaxLifeSeconds = ").append(this.getMaxLifeSeconds()).append(", IdleTime = ").append(this.getIdleTime()).append(", CreateTime = ").append(this.getCreateTime()).append(", LastAccessTime = ").append(this.getLastAccessTime()).append(", getTimeToLiveSeconds() = ").append(String.valueOf(this.getTimeToLiveSeconds())).append(", createTime = ").append(String.valueOf(this.createTime)).append(" ]");
        return dump.toString();
    }
}

