/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.excalibur.source.Source;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CastorTransformer
extends AbstractTransformer
implements Configurable {
    private static final String CASTOR_URI = "http://apache.org/cocoon/castor/1.0";
    private static final String CMD_UNMARSHAL = "unmarshal";
    private static final String CMD_MARSHAL = "marshal";
    private static final String ATTRIB_NAME = "name";
    private static final String ATTRIB_SCOPE = "scope";
    private static final String SCOPE_SITEMAP = "sitemap";
    private static final String SCOPE_SESSION = "session";
    private static final String SCOPE_REQUEST = "request";
    private static final String ATTRIB_MAPPING = "mapping";
    private static HashMap mappings;
    private Map prefixMap = new HashMap();
    private Unmarshaller unmarshaller;
    private UnmarshalHandler unmarshalHandler;
    private ContentHandler unmarshalContentHandler;
    private String beanName;
    private String beanScope;
    private Map objectModel;
    private SourceResolver resolver;
    private String defaultMappingName;
    private Mapping defaultMapping;
    private boolean in_castor_element = false;
    static /* synthetic */ Class class$org$apache$cocoon$transformation$CastorTransformer;

    public void configure(Configuration conf) throws ConfigurationException {
        this.defaultMappingName = conf.getChild(ATTRIB_MAPPING).getValue();
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters params) throws ProcessingException, SAXException, IOException {
        block2: {
            this.objectModel = objectModel;
            this.resolver = resolver;
            if (this.defaultMappingName == null) break block2;
            try {
                this.defaultMapping = this.loadMapping(this.defaultMappingName);
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to load mapping " + this.defaultMappingName, (Throwable)e);
            }
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (CASTOR_URI.equals(uri)) {
            this.in_castor_element = false;
        } else if (this.unmarshalContentHandler != null) {
            if (CASTOR_URI.equals(uri) && CMD_UNMARSHAL.equals(name)) {
                Iterator itt = this.prefixMap.entrySet().iterator();
                while (itt.hasNext()) {
                    Map.Entry entry = itt.next();
                    this.unmarshalContentHandler.endPrefixMapping((String)entry.getKey());
                }
                this.unmarshalContentHandler.endDocument();
                this.unmarshalContentHandler = null;
                Object root = this.unmarshalHandler.getObject();
                this.storeBean(this.objectModel, this.beanName, this.beanScope, root);
            } else {
                this.unmarshalContentHandler.endElement(uri, name, raw);
            }
        } else if (!CASTOR_URI.equals(uri)) {
            super.endElement(uri, name, raw);
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (CASTOR_URI.equals(uri)) {
            this.in_castor_element = true;
            this.process(name, attr);
        } else {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        if (!this.in_castor_element) {
            super.characters(ch, start, len);
        }
    }

    private void process(String command, Attributes attr) throws SAXException {
        if (command.equals(CMD_MARSHAL)) {
            String scope = attr.getValue(ATTRIB_SCOPE);
            String name = attr.getValue(ATTRIB_NAME);
            String mapping = attr.getValue(ATTRIB_MAPPING);
            if (name == null) {
                this.getLogger().error("Attribute to insert not set");
            } else {
                this.marshal(this.objectModel, name, scope, mapping);
            }
        } else if (command.equals(CMD_UNMARSHAL)) {
            this.beanScope = attr.getValue(ATTRIB_SCOPE);
            this.beanName = attr.getValue(ATTRIB_NAME);
            if (this.beanScope == null) {
                this.getLogger().error("Destination for unmarshalled bean not set");
                return;
            }
            if (this.beanName == null) {
                this.getLogger().error("Name of unmarshalled bean not set");
                return;
            }
            String mappingpath = attr.getValue(ATTRIB_MAPPING);
            this.unmarshaller = new Unmarshaller((Class)null);
            if (mappingpath != null) {
                try {
                    Mapping mapping = this.loadMapping(mappingpath);
                    this.unmarshaller.setMapping(mapping);
                }
                catch (MappingException e) {
                    this.getLogger().error("Could not load mapping file " + mappingpath, (Throwable)e);
                }
                catch (IOException e) {
                    this.getLogger().error("Could not load mapping file " + mappingpath, (Throwable)e);
                }
            }
            this.unmarshalHandler = this.unmarshaller.createHandler();
            try {
                this.unmarshalContentHandler = Unmarshaller.getContentHandler((UnmarshalHandler)this.unmarshalHandler);
                this.unmarshalContentHandler.startDocument();
                Iterator itt = this.prefixMap.entrySet().iterator();
                while (itt.hasNext()) {
                    Map.Entry entry = itt.next();
                    this.unmarshalContentHandler.startPrefixMapping((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (SAXException e) {
                this.getLogger().error("Could not get contenthandler from unmarshaller", (Throwable)e);
            }
        } else {
            throw new SAXException("Unknown command: " + command);
        }
    }

    private void marshal(Map objectModel, String name, String scope, String mappingpath) {
        try {
            Marshaller marshaller = new Marshaller((ContentHandler)new IncludeXMLConsumer(this.contentHandler));
            try {
                Mapping mapping = null;
                mapping = mappingpath != null ? this.loadMapping(mappingpath) : this.defaultMapping;
                marshaller.setMapping(mapping);
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to load mapping " + mappingpath, (Throwable)e);
            }
            Object bean = this.searchBean(objectModel, name, scope);
            if (bean instanceof Collection) {
                Iterator i = ((Collection)bean).iterator();
                while (i.hasNext()) {
                    marshaller.marshal(i.next());
                }
            } else {
                marshaller.marshal(bean);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Failed to marshal bean " + name, (Throwable)e);
        }
    }

    private Object searchBean(Map objectModel, String name, String scope) {
        Session session;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (scope == null || SCOPE_SITEMAP.equals(scope)) {
            return objectModel.get(name);
        }
        if (scope == null || SCOPE_REQUEST.equals(scope)) {
            return request.getAttribute(name);
        }
        if ((scope == null || SCOPE_SESSION.equals(scope)) && (session = request.getSession(false)) != null) {
            return session.getAttribute(name);
        }
        return null;
    }

    private void storeBean(Map objectModel, String name, String scope, Object bean) {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        if (SCOPE_SITEMAP.equals(scope)) {
            objectModel.put(name, bean);
        } else if (SCOPE_REQUEST.equals(scope)) {
            request.setAttribute(name, bean);
        } else if (SCOPE_SESSION.equals(scope)) {
            Session session = request.getSession(true);
            session.setAttribute(name, bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mapping loadMapping(String file) throws MappingException, IOException {
        Class clazz = class$org$apache$cocoon$transformation$CastorTransformer == null ? (class$org$apache$cocoon$transformation$CastorTransformer = CastorTransformer.class$("org.apache.cocoon.transformation.CastorTransformer")) : class$org$apache$cocoon$transformation$CastorTransformer;
        synchronized (clazz) {
            Mapping mapping;
            if (mappings == null) {
                mappings = new HashMap();
            }
            Source source = this.resolver.resolveURI(file);
            try {
                mapping = (Mapping)mappings.get(source.getURI());
                if (mapping == null) {
                    mapping = new Mapping();
                    InputSource in = new InputSource(source.getInputStream());
                    mapping.loadMapping(in);
                    mappings.put(source.getURI(), mapping);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.resolver.release(source);
                throw throwable;
            }
            this.resolver.release(source);
            return mapping;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

