/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.caching.Cache;
import org.apache.cocoon.components.source.impl.CachingSource;
import org.apache.cocoon.components.source.impl.Refresher;
import org.apache.cocoon.components.source.impl.TraversableCachingSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.URIAbsolutizer;

public final class CachingSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
URIAbsolutizer,
Serviceable,
Configurable,
Disposable,
ThreadSafe {
    private String scheme;
    private boolean async;
    private String cacheRole;
    private String refresherRole;
    private int defaultExpires;
    private boolean isInitialized;
    protected ServiceManager manager;
    protected SourceResolver resolver;
    protected Refresher refresher;
    protected Cache cache;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.scheme = configuration.getAttribute("name");
        Parameters parameters = Parameters.fromConfiguration((Configuration)configuration);
        this.async = parameters.getParameterAsBoolean("async", false);
        this.cacheRole = parameters.getParameter("cache-role", Cache.ROLE);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Using cache " + this.cacheRole);
        }
        if (this.async) {
            this.refresherRole = parameters.getParameter("refresher-role", Refresher.ROLE);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Using refresher " + this.refresherRole);
            }
        }
        this.defaultExpires = parameters.getParameterAsInteger("default-expires", -1);
    }

    private synchronized void lazyInitialize() throws SourceException {
        if (this.isInitialized) {
            return;
        }
        try {
            this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
        }
        catch (ServiceException se) {
            throw new SourceException("Missing service dependency: " + SourceResolver.ROLE, (Throwable)se);
        }
        try {
            this.cache = (Cache)this.manager.lookup(this.cacheRole);
        }
        catch (ServiceException se) {
            throw new SourceException("Missing service dependency: " + this.cacheRole, (Throwable)se);
        }
        if (this.async) {
            try {
                this.refresher = (Refresher)this.manager.lookup(this.refresherRole);
            }
            catch (ServiceException se) {
                if (this.resolver != null) {
                    this.manager.release((Object)this.resolver);
                    this.resolver = null;
                }
                throw new SourceException("Missing service dependency: " + this.refresherRole, (Throwable)se);
            }
        }
        this.isInitialized = true;
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.resolver);
            this.manager.release((Object)this.refresher);
            this.refresher = null;
            this.manager = null;
            this.resolver = null;
        }
    }

    public Source getSource(String location, Map parameters) throws MalformedURLException, IOException {
        int expires;
        int index;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Creating source object for " + location);
        }
        if (!this.isInitialized) {
            this.lazyInitialize();
        }
        if ((index = location.indexOf(58)) == -1) {
            throw new MalformedURLException("This Source requires a subprotocol to be specified.");
        }
        String uri = location.substring(index + 1);
        SourceParameters sp = null;
        String queryString = null;
        index = uri.indexOf(63);
        if (index != -1) {
            queryString = uri.substring(index + 1);
            uri = uri.substring(0, index);
            sp = new SourceParameters(queryString);
        }
        Parameters params = new Parameters();
        if (sp != null) {
            Iterator names = sp.getParameterNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (!name.startsWith("cocoon:cache")) continue;
                params.setParameter(name.substring("cocoon:".length()), sp.getParameter(name));
                sp.removeParameter(name);
            }
            queryString = sp.getQueryString();
            if (queryString != null) {
                uri = uri + "?" + queryString;
            }
        }
        if ((expires = params.getParameterAsInteger("cache-expires", -1)) == -1) {
            expires = this.defaultExpires;
            params.setParameter("cache-expires", String.valueOf(this.defaultExpires));
        }
        params.setParameter("cache-role", this.cacheRole);
        Source wrappedSource = this.resolver.resolveURI(uri);
        CachingSource source = wrappedSource instanceof TraversableSource ? new TraversableCachingSource(this.scheme, location, (TraversableSource)wrappedSource, params, expires, this.async) : new CachingSource(this.scheme, location, wrappedSource, params, expires, this.async);
        source.cache = this.cache;
        source.resolver = this.resolver;
        source.refresher = this.refresher;
        ContainerUtil.enableLogging((Object)((Object)source), (Logger)this.getLogger());
        try {
            ContainerUtil.service((Object)((Object)source), (ServiceManager)this.manager);
            ContainerUtil.initialize((Object)((Object)source));
        }
        catch (ServiceException se) {
            throw new SourceException("Unable to initialize source.", (Throwable)se);
        }
        catch (Exception e) {
            throw new SourceException("Unable to initialize source.", (Throwable)e);
        }
        return source;
    }

    public void release(Source source) {
        if (source instanceof CachingSource) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Releasing source " + source.getURI());
            }
            ((CachingSource)source).dispose();
        }
    }

    public String absolutize(String baseURI, String location) {
        return SourceUtil.absolutize((String)baseURI, (String)location, (boolean)true);
    }
}

