/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.util;

import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class I18nMessage
implements XMLizable {
    private String key;
    private String catalogue;
    private String[] parameters;
    private boolean[] keys;

    public I18nMessage(String key) {
        this(key, (String)null);
    }

    public I18nMessage(String key, String catalogue) {
        this.key = key;
        this.catalogue = catalogue;
    }

    public I18nMessage(String key, String[] parameters) {
        this(key, parameters, (String)null);
    }

    public I18nMessage(String key, String[] parameters, String catalogue) {
        this.key = key;
        this.parameters = parameters;
        this.catalogue = catalogue;
    }

    public I18nMessage(String key, String[] parameters, boolean[] keys) {
        this(key, parameters, keys, null);
    }

    public I18nMessage(String key, String[] parameters, boolean[] keys, String catalogue) {
        this.key = key;
        this.parameters = parameters;
        this.keys = keys;
        this.catalogue = catalogue;
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        contentHandler.startPrefixMapping("i18n", "http://apache.org/cocoon/i18n/2.1");
        if (this.parameters != null) {
            contentHandler.startElement("http://apache.org/cocoon/i18n/2.1", "translate", "i18n:translate", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
        }
        AttributesImpl i18nAttrs = new AttributesImpl();
        if (this.catalogue != null) {
            i18nAttrs.addCDATAAttribute("http://apache.org/cocoon/i18n/2.1", "catalogue", "i18n:catalogue", this.catalogue);
        }
        contentHandler.startElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text", (Attributes)i18nAttrs);
        contentHandler.characters(this.key.toCharArray(), 0, this.key.length());
        contentHandler.endElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text");
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                contentHandler.startElement("http://apache.org/cocoon/i18n/2.1", "param", "i18n:param", (Attributes)XMLUtils.EMPTY_ATTRIBUTES);
                if (this.keys != null && this.keys[i]) {
                    contentHandler.startElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text", (Attributes)i18nAttrs);
                }
                contentHandler.characters(this.parameters[i].toCharArray(), 0, this.parameters[i].length());
                if (this.keys != null && this.keys[i]) {
                    contentHandler.endElement("http://apache.org/cocoon/i18n/2.1", "text", "i18n:text");
                }
                contentHandler.endElement("http://apache.org/cocoon/i18n/2.1", "param", "i18n:param");
                ++i;
            }
            contentHandler.endElement("http://apache.org/cocoon/i18n/2.1", "translate", "i18n:translate");
        }
        contentHandler.endPrefixMapping("i18n");
    }
}

