/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.transformation;

import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.forms.formmodel.Form;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Variables;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FormsPipelineConfig {
    public static final String CFORMSKEY = "CocoonFormsInstance";
    private final String attributeName;
    private final Request request;
    private final JXPathContext jxpathContext;
    private final Locale localeParameter;
    private Locale locale;
    private String formAction;
    private String formMethod;

    private FormsPipelineConfig(JXPathContext jxpc, Request req, Locale localeParam, String attName, String actionExpression, String method) {
        this.attributeName = attName;
        this.request = req;
        this.jxpathContext = jxpc;
        this.localeParameter = localeParam;
        this.formAction = this.translateText(actionExpression);
        this.formMethod = method;
    }

    public static FormsPipelineConfig createConfig(Map objectModel, Parameters parameters) {
        Object flowContext = FlowHelper.getContextObject((Map)objectModel);
        WebContinuation wk = FlowHelper.getWebContinuation((Map)objectModel);
        JXPathContext jxpc = JXPathContext.newContext((Object)flowContext);
        Variables vars = jxpc.getVariables();
        vars.declareVariable("continuation", (Object)wk);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        vars.declareVariable("request", (Object)request);
        Session session = request.getSession(false);
        vars.declareVariable("session", (Object)session);
        vars.declareVariable("parameters", (Object)parameters);
        Locale localeParameter = null;
        String localeStr = parameters.getParameter("locale", null);
        if (localeStr != null) {
            localeParameter = I18nUtils.parseLocale((String)localeStr);
        }
        String attributeName = parameters.getParameter("attribute-name", null);
        String actionExpression = parameters.getParameter("form-action", null);
        String formMethod = parameters.getParameter("form-method", null);
        return new FormsPipelineConfig(jxpc, request, localeParameter, attributeName, actionExpression, formMethod);
    }

    public Form findForm() throws SAXException {
        return this.findForm(null);
    }

    public Form findForm(String jxpathExpression) throws SAXException {
        Object form = null;
        if (jxpathExpression != null) {
            form = this.jxpathContext.getValue(jxpathExpression);
            if (form == null) {
                throw new SAXException("No Cocoon Form found at location \"" + jxpathExpression + "\".");
            }
            if (!(form instanceof Form)) {
                throw new SAXException("Object returned by expression \"" + jxpathExpression + "\" is not a Cocoon Form.");
            }
        } else if (this.attributeName != null) {
            form = this.request.getAttribute(this.attributeName);
            if (form == null) {
                throw new SAXException("No Cocoon Form found in request attribute with name \"" + this.attributeName + "\"");
            }
            if (!(form instanceof Form)) {
                throw new SAXException("Object found in request (attribute = '" + this.attributeName + "') is not a Cocoon Form.");
            }
        } else {
            jxpathExpression = "/CocoonFormsInstance";
            try {
                form = this.jxpathContext.getValue(jxpathExpression);
            }
            catch (JXPathException e) {
                // empty catch block
            }
            if (form == null) {
                throw new SAXException("No Cocoon Form found.");
            }
        }
        return (Form)form;
    }

    /*
     * Unable to fully structure code
     */
    public String translateText(String original) {
        if (original == null) {
            return null;
        }
        translated = new StringBuffer();
        in = new StringReader(original);
lbl5:
        // 2 sources

        try {
            while ((chr = in.read()) != -1) {
                block8: {
                    block9: {
                        c = (char)var5_5;
                        if (c != '#') break block8;
                        chr = in.read();
                        if (chr == -1) break block9;
                        c = (char)chr;
                        if (c != '{') continue;
                        expression = new StringBuffer();
                        more = true;
                        while (more) {
                            more = false;
                            chr = in.read();
                            if (chr != -1) {
                                c = (char)chr;
                                if (c != '}') {
                                    expression.append(c);
                                    more = true;
                                    continue;
                                }
                                translated.append(this.evaluateExpression(expression.toString()).toString());
                                continue;
                            }
                            translated.append('#').append('{').append(expression);
                        }
                        ** GOTO lbl5
                    }
                    translated.append((char)chr);
                    continue;
                }
                translated.append(c);
            }
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
        return translated.toString();
    }

    public Object evaluateExpression(String expression) {
        return this.jxpathContext.getValue(expression);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocaleParameter() {
        return this.localeParameter;
    }

    public String getFormAction() {
        return this.formAction;
    }

    public String getFormMethod() {
        return this.formMethod;
    }

    public void setFormMethod(String method) {
        this.formMethod = method;
    }

    public Attributes getFormAttributes() {
        AttributesImpl formAtts = new AttributesImpl();
        if (this.getFormAction() != null) {
            formAtts.addCDATAAttribute("action", this.getFormAction());
        }
        if (this.getFormMethod() != null) {
            formAtts.addCDATAAttribute("method", this.getFormMethod());
        }
        return formAtts;
    }
}

