/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.formmodel;

import org.apache.cocoon.forms.FormContext;
import org.apache.cocoon.forms.formmodel.AbstractContainerWidget;
import org.apache.cocoon.forms.formmodel.ContainerWidget;
import org.apache.cocoon.forms.formmodel.UnionDefinition;
import org.apache.cocoon.forms.formmodel.Widget;
import org.apache.cocoon.forms.formmodel.WidgetDefinition;

public class Union
extends AbstractContainerWidget {
    private static final String UNION_EL = "field";
    private Widget caseWidget;
    private final UnionDefinition definition;

    public Union(UnionDefinition definition) {
        this.definition = definition;
    }

    protected WidgetDefinition getDefinition() {
        return this.definition;
    }

    public void setParent(Widget widget) {
        super.setParent(widget);
        this.resolve();
    }

    public void resolve() {
        String caseWidgetId = this.definition.getCaseWidgetId();
        this.caseWidget = ((ContainerWidget)this.getParent()).getChild(caseWidgetId);
    }

    public String getXMLElementName() {
        return UNION_EL;
    }

    public Object getValue() {
        return this.caseWidget.getValue();
    }

    public void readFromRequest(FormContext formContext) {
        Widget widget;
        this.caseWidget.readFromRequest(formContext);
        String value = (String)this.getValue();
        if (value != null && !value.equals("") && (widget = this.getChild(value)) != null) {
            widget.readFromRequest(formContext);
        }
    }

    public boolean validate() {
        Widget widget;
        boolean valid = true;
        String value = (String)this.getValue();
        if (value != null && !value.equals("") && (widget = this.getChild(value)) != null) {
            valid &= widget.validate();
        }
        return valid;
    }

    public Widget getChild(String id) {
        if (!this.widgets.hasWidget(id) && this.definition.hasWidget(id)) {
            this.definition.createWidget(this, id);
        }
        return super.getChild(id);
    }
}

