/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.user;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.user.AbstractIdentity;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Property;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.xml.sax.SAXParser;

public class User
extends AbstractIdentity {
    private Locale preferredLocale;
    private String xmlLang = "";
    private String firstname;
    private String lastname;
    private String email;
    private StringBuffer characterBuffer;
    private String currentFieldName;
    public static final String XCONF_FIRSTNAME = "firstname";
    public static final String XCONF_LASTNAME = "lastname";
    public static final String XCONF_EMAIL = "email";
    public static final String XCONF_LANG = "lang";
    public static final String XCONF_VARIANT = "variant";

    public String getDocType() {
        return "user";
    }

    public User() throws SDXException {
    }

    public User(String username) throws SDXException {
        super(username);
    }

    public void startIndexing(SAXParser parser, XMLConsumer consumer) throws SDXException {
        super.startIndexing(parser, consumer);
        Enumeration values = this.getFieldValues();
        if (values != null) {
            String xmlLang = "";
            String variant = "";
            while (values.hasMoreElements()) {
                Property prop = (Property)values.nextElement();
                String name = prop.getName();
                if (name.equals(XCONF_FIRSTNAME)) {
                    this.firstname = prop.getValue();
                }
                if (name.equals(XCONF_LASTNAME)) {
                    this.lastname = prop.getValue();
                }
                if (name.equals(XCONF_LANG)) {
                    xmlLang = prop.getValue();
                }
                if (name.equals(XCONF_VARIANT)) {
                    variant = prop.getValue();
                }
                if (!name.equals(XCONF_EMAIL)) continue;
                this.email = prop.getValue();
            }
            this.preferredLocale = Utilities.buildLocale(xmlLang, variant, null);
            this.xmlLang = xmlLang;
        }
    }

    public String getXmlLang() {
        return this.xmlLang;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public Locale getPreferredLocale() {
        return this.preferredLocale;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

