/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.sitemap.serialization;

import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.serialization.AbstractTextSerializer;

public class GzipXMLSerializer
extends AbstractTextSerializer {
    private TransformerHandler handler;
    private GZIPOutputStream gzop;

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        this.format.put("method", "xml");
    }

    public void setOutputStream(OutputStream out) {
        try {
            this.gzop = new GZIPOutputStream(out);
            super.setOutputStream(out);
            this.handler = this.getTransformerFactory().newTransformerHandler();
            this.handler.getTransformer().setOutputProperties(this.format);
            this.handler.setResult(new StreamResult(this.gzop));
            this.setContentHandler(this.handler);
            this.setLexicalHandler(this.handler);
        }
        catch (Exception e) {
            this.getLogger().error("XMLSerializer.setOutputStream()", (Throwable)e);
            throw new CascadingRuntimeException("XMLSerializer.setOutputStream()", (Throwable)e);
        }
    }

    public void endDocument() {
        try {
            super.endDocument();
            this.gzop.finish();
            this.gzop.close();
        }
        catch (Exception e) {
            System.out.println("endDocument() died: " + e);
        }
    }

    public void recycle() {
        super.recycle();
        this.handler = null;
    }
}

