/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.utils.Date;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.RangeQuery;

public class SDXRangeQuery
extends RangeQuery {
    public SDXRangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive) {
        super(lowerTerm, upperTerm, inclusive);
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(super.isInclusive() ? "[" : "{");
        buffer.append(super.getLowerTerm() != null ? Date.formatDate(DateField.stringToDate(super.getLowerTerm().text())) : "null");
        buffer.append(" TO ");
        buffer.append(super.getUpperTerm() != null ? Date.formatDate(DateField.stringToDate(super.getUpperTerm().text())) : "null");
        buffer.append(super.isInclusive() ? "]" : "}");
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }
}

