/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.documentbase.DefaultIDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.pipeline.Transformation;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.xml.AbstractSdxXMLPipe;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;

public abstract class AbstractTransformation
extends AbstractSdxXMLPipe
implements Transformation {
    protected static final String PARAMETER_NAME_DISABLE = "disable";
    protected static final String PARAMETER_NAME_ENABLE = "enable";
    protected Parameters parameters;
    protected Parameters transParameters;
    private boolean keepResult = false;

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters p) {
        this.parameters = p;
    }

    public void recycle() {
        super.recycle();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        try {
            super.setId(configuration.getAttribute("id", new DefaultIDGenerator().generate()));
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
        }
        super.configure(configuration);
        this.keepResult = configuration.getAttributeAsBoolean("keep", false);
        if (configuration != null) {
            this.transParameters = Parameters.fromConfiguration((Configuration)configuration);
            this.verifyConfigurationParameters(this.transParameters);
        }
    }

    protected void verifyConfigurationParameters(Parameters params) {
        if (params != null) {
            String[] paramNames = params.getNames();
            for (int i = 0; i < paramNames.length; ++i) {
                String paramValue;
                String paramName = paramNames[i];
                if (!Utilities.checkString(paramName) || (paramValue = params.getParameter(paramName, null)) != null && !paramValue.equals("null")) continue;
                params.removeParameter(paramName);
            }
        }
    }

    public boolean shouldKeepResult() {
        return this.keepResult;
    }

    protected boolean isStepEnabled() {
        String enable;
        boolean enabled = true;
        if (this.transParameters != null && (enabled = Boolean.getBoolean(enable = this.transParameters.getParameter(PARAMETER_NAME_ENABLE, "true")))) {
            String disable = this.transParameters.getParameter(PARAMETER_NAME_DISABLE, "false");
            boolean bl = enabled = !Boolean.getBoolean(disable);
        }
        if (this.parameters != null) {
            if (!enabled) {
                String enableTransId = this.parameters.getParameter(PARAMETER_NAME_ENABLE, null);
                if (Utilities.checkString(enableTransId) && enableTransId.equals(this.getId())) {
                    enabled = true;
                }
            } else {
                String disableTransId = this.parameters.getParameter(PARAMETER_NAME_DISABLE, null);
                if (Utilities.checkString(disableTransId) && disableTransId.equals(this.getId())) {
                    enabled = false;
                }
            }
        }
        return enabled;
    }

    protected String getClassNameSuffix() {
        return "Transformation";
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("ID", this.getId());
        this._xmlizable_objects.put("Encoding", this.getEncoding());
        this._xmlizable_objects.put("XML-Lang", this.getXmlLang());
        this._xmlizable_objects.put("Locale", this.getLocale().toString());
        this._xmlizable_objects.put("Keep_Result", String.valueOf(this.keepResult));
        return true;
    }

    protected void initVolatileObjectsToSax() {
        this._xmlizable_objects.put("Keep_Result", String.valueOf(this.keepResult));
    }
}

