/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.documentbase;

import com.icl.saxon.TransformerFactoryImpl;
import fr.gouv.culture.sdx.document.BinaryDocument;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.HTMLDocument;
import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.document.OAIDocument;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.documentbase.AbstractDocumentBase;
import fr.gouv.culture.sdx.documentbase.IndexParameters;
import fr.gouv.culture.sdx.documentbase.SDXDocumentBaseTarget;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.repository.FSRepository;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.repository.URLRepository;
import fr.gouv.culture.sdx.search.lucene.query.FieldQuery;
import fr.gouv.culture.sdx.search.lucene.query.Results;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.user.User;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.SimpleTimeScheduler;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeScheduler;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeTrigger;
import fr.gouv.culture.util.apache.avalon.cornerstone.services.scheduler.TimeTriggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class SDXDocumentBase
extends AbstractDocumentBase
implements SDXDocumentBaseTarget {
    protected TimeScheduler scheduler = null;
    protected boolean keepOriginalDocuments = true;
    protected String baseIndexDir;
    protected boolean splitActive = false;
    protected long splitSize = 524288000L;
    protected String splitUnit = "m";
    protected long splitDoc = 500000L;
    protected boolean useCompoundFiles = true;
    protected boolean autoOptimize = true;
    protected boolean _isIndexOptimized = false;
    protected final String DOC_URL = "docUrl";
    protected final String SDX_USER = "sdxUser";
    protected final String SDX_DATE = "sdxDate";
    protected final String SDX_ISO8601_DATE = "sdxISO8601Date";
    protected final String SDX_DATE_MILLISECONDS = "sdxDateMilliseconds";
    protected static final String[] _documentAdditionStatus = new String[]{"failure", "ignored", "added", "refreshed", "replaced"};
    protected static final int DOC_ADD_STATUS_FAILURE = 0;
    protected static final int DOC_ADD_STATUS_IGNORED = 1;
    protected static final int DOC_ADD_STATUS_ADDED = 2;
    protected static final int DOC_ADD_STATUS_REFRESHED = 3;
    protected static final int DOC_ADD_STATUS_REPLACED = 4;
    protected static final String SDX_DATABASE_FORMAT = "sdx_database_format";
    protected static final String SDX_DATABASE_VERSION = "sdx_database_version";
    protected static final String SDX_DATABASE_VERSION_2_3 = "sdx_2.3";
    protected static final String ELEMENT_NAME_DEFAULT_HPP = "default_hpp";
    protected static final String ELEMENT_NAME_DEFAULT_MAXSORT = "default_maxsort";
    protected Configuration _configuration;

    protected void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this._configuration;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.setConfiguration(configuration);
        this.configureBase(configuration);
        super.configure(configuration, this.isUseMetadata());
        this.configureSplit(configuration);
        this.configurePipeline(configuration);
        this.configureIdGenerator(configuration);
        this.configureRepositories(configuration);
        this.configureDocumentBase(configuration);
        this.configureOAIComponents(configuration);
    }

    protected void configureBase(Configuration configuration) throws ConfigurationException {
        String dbDirPath = "";
        if (configuration.getName().toLowerCase().indexOf("DocumentBase".toLowerCase()) > -1) {
            try {
                this.keepOriginalDocuments = configuration.getAttributeAsBoolean("keepOriginalDocuments", true);
                this.useCompoundFiles = configuration.getAttributeAsBoolean("useCompoundFiles", true);
                this.setId(configuration.getAttribute("id", super.getId()));
                this.autoOptimize = configuration.getAttributeAsBoolean("autoOptimize", true);
                this.configureOptimizeTriggers(configuration.getChild("optimization", false));
            }
            catch (SDXException sdxE) {
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
            }
            if (!Utilities.checkString(this.getId())) {
                String[] args = new String[]{configuration.getLocation()};
                SDXException sdxE = new SDXException(super.getLog(), 18, args, null);
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
            }
            dbDirPath = Utilities.getStringFromContext("sdx.application.dbsDirPath", (Context)super.getContext()) + this.getId() + File.separator;
            this.useMetadata = configuration.getAttributeAsBoolean(this.ATTRIBUTE_USE_METADATA, true);
            if (!this.isUseMetadata()) {
                // empty if block
            }
        } else {
            String[] args = new String[]{configuration.getName()};
            SDXException sdxE = new SDXException(null, 31, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)((Object)sdxE));
        }
        super.getContext().put((Object)"sdx.documentbase.dbDirPath", (Object)dbDirPath);
        try {
            Configuration sdxConf = (Configuration)super.getContext().get((Object)"sdx.framework.confFile");
            if (sdxConf != null) {
                Configuration iFConf = sdxConf.getChild(ELEMENT_NAME_DEFAULT_HPP, false);
                if (iFConf != null) {
                    this.defaultHitsPerPage = iFConf.getAttributeAsInteger("hpp", this.defaultHitsPerPage);
                } else {
                    this.getLog().warn("No default_hpp value in sdx's configuration file.");
                }
                iFConf = sdxConf.getChild(ELEMENT_NAME_DEFAULT_MAXSORT, false);
                if (iFConf != null) {
                    this.defaultMaxSort = iFConf.getAttributeAsInteger("maxsort", this.defaultMaxSort);
                } else {
                    this.getLog().warn("No default_maxsort value in sdx's configuration file.");
                }
            }
        }
        catch (ContextException contextException) {
            // empty catch block
        }
        this.isDefault = configuration.getAttributeAsBoolean("default", false);
        this.defaultMaxSort = configuration.getAttributeAsInteger("maxsort", this.defaultMaxSort);
        this.defaultHitsPerPage = configuration.getAttributeAsInteger("hpp", this.defaultHitsPerPage);
    }

    protected void configureSplit(Configuration configuration) throws ConfigurationException {
        if (configuration.getName().toLowerCase().indexOf("DocumentBase".toLowerCase()) > -1) {
            Configuration splitConfig = configuration.getChild("split", false);
            if (splitConfig != null) {
                this.splitActive = true;
                this.splitSize = splitConfig.getAttributeAsLong("size", 500L);
                this.splitUnit = splitConfig.getAttribute("unit", "m");
                this.splitDoc = splitConfig.getAttributeAsLong("nbDocuments", 500000L);
                if (this.splitSize < 0L) {
                    this.splitSize = 0L;
                } else if (this.splitUnit.equalsIgnoreCase("k")) {
                    this.splitSize *= 1024L;
                } else if (this.splitUnit.equalsIgnoreCase("m")) {
                    this.splitSize *= 0x100000L;
                } else if (this.splitUnit.equalsIgnoreCase("g")) {
                    this.splitSize *= 0x40000000L;
                }
                if (this.splitDoc < 0L) {
                    this.splitDoc = 0L;
                }
            } else {
                this.splitActive = false;
                this.splitSize = 524288000L;
                this.splitUnit = "m";
                this.splitDoc = 500000L;
            }
        }
    }

    protected Configuration[] getRepositoryConfigurationList(Configuration configuration) throws ConfigurationException {
        String elementName = Utilities.getElementName("Repository");
        Configuration[] repoConfList = new Configuration[configuration.getChild("repositories").getChildren(elementName).length];
        repoConfList = configuration.getChild("repositories").getChildren(elementName);
        if (repoConfList == null || repoConfList.length == 0) {
            super.getLog().warn("There is no repositories in " + this.getId());
        }
        return repoConfList;
    }

    protected void configureRepositories(Configuration configuration) throws ConfigurationException {
        Configuration[] repoConfList = this.getRepositoryConfigurationList(configuration);
        if (this.repositories == null) {
            this.repositories = new Hashtable();
        }
        Repository firstRepository = null;
        if (!this.isUseMetadata() && repoConfList.length > 1) {
            throw new ConfigurationException("You must use metadata if you use more than one repository", configuration);
        }
        for (int i = 0; i < repoConfList.length; ++i) {
            Repository repo = null;
            try {
                String ref = repoConfList[i].getAttribute("ref", null);
                if (Utilities.checkString(ref)) {
                    Context appRepos = (Context)super.getContext().get((Object)"sdx.application.repos");
                    if (appRepos != null) {
                        repo = (Repository)appRepos.get((Object)ref);
                    }
                    if (repo == null) {
                        String[] args = new String[]{ref};
                        throw new SDXException(super.getLog(), 29, args, null);
                    }
                    repo.setIsDefault(repoConfList[i].getAttributeAsBoolean("default", false));
                } else {
                    repo = ConfigurationUtils.createRepository(super.getLog(), (Context)super.getContext(), super.getServiceManager(), repoConfList[i]);
                }
                if (!this.isUseMetadata()) {
                    if (repo instanceof URLRepository) {
                        throw new ConfigurationException("You must use metadata if you use URLrepository", configuration);
                    }
                    if (repo instanceof FSRepository) {
                        throw new ConfigurationException("You must use metadata if you use FSRepository", configuration);
                    }
                }
                Utilities.isObjectUnique(this.repositories, null, (Object)repo);
                this.repositories.put(repo.getId(), repo);
                if (repo.isDefault()) {
                    this.defaultRepository = repo;
                }
                if (i != 0) continue;
                firstRepository = repo;
                continue;
            }
            catch (SDXException e) {
                continue;
            }
            catch (ConfigurationException e) {
                LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
                continue;
            }
            catch (ContextException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.defaultRepository == null) {
            this.defaultRepository = firstRepository;
        }
    }

    public void configureOAIComponents(Configuration configuration) throws ConfigurationException {
        this.configureOAIRepository(configuration);
        this.configureOAIHarvester(configuration);
    }

    protected void configureIdGenerator(Configuration configuration) throws ConfigurationException {
        this.idGen = ConfigurationUtils.configureIDGenerator(super.getLog(), configuration);
        if (!this.isUseMetadata()) {
            this.idGen.setDatabase(this._database);
        }
    }

    protected abstract void configureDocumentBase(Configuration var1) throws ConfigurationException;

    protected abstract void deleteFromSearchIndex(String var1) throws SDXException;

    protected abstract void configureOAIRepository(Configuration var1) throws ConfigurationException;

    protected abstract void configureOAIHarvester(Configuration var1) throws ConfigurationException;

    protected abstract Object getIndexationDocument(IndexableDocument var1, String var2, String var3, IndexParameters var4) throws SDXException;

    protected abstract void addToSearchIndex(Object var1, boolean var2) throws SDXException;

    protected abstract void compactSearchIndex() throws SDXException;

    public boolean getUseCompoundFiles() {
        return this.useCompoundFiles;
    }

    public boolean isAutoOptimized() {
        return this.autoOptimize;
    }

    protected long getByteSplitSize() {
        return this.splitSize;
    }

    public long getSplitSize() {
        if (this.splitUnit.equalsIgnoreCase("k")) {
            return this.splitSize / 1024L;
        }
        if (this.splitUnit.equalsIgnoreCase("m")) {
            return this.splitSize / 0x100000L;
        }
        if (this.splitUnit.equalsIgnoreCase("g")) {
            return this.splitSize / 0x40000000L;
        }
        return this.splitSize;
    }

    public String getSplitUnit() {
        return this.splitUnit;
    }

    public long getSplitDoc() {
        return this.splitDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDocument(ParsableDocument doc, XMLConsumer consumer) throws SDXException {
        super.getDocument(doc, consumer);
        Repository repo = null;
        RepositoryConnection conn = null;
        try {
            repo = this.getRepositoryForDocument(doc);
            if (repo != null) {
                conn = repo.getConnection();
            }
            if (repo != null && conn != null) {
                repo.toSAX(doc, consumer, conn);
            }
            Object var6_5 = null;
            if (repo != null && conn != null) {
                repo.releaseConnection(conn);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (repo != null && conn != null) {
                repo.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    public void getDocument(ParsableDocument doc, XMLConsumer consumer, boolean docTypeKnown) throws SDXException {
        super.getDocument(doc, consumer);
        if (this.isUseMetadata() && !docTypeKnown) {
            DatabaseEntity ent = this._database.getEntity(doc.getId());
            if (ent == null) {
                String[] args = new String[]{doc.getId(), this.getId()};
                throw new SDXException(super.getLog(), 2000, args, null);
            }
            ent.enableLogging(super.getLog());
            String doctype = ent.getProperty("sdxDocType");
            if (Utilities.checkString(doctype)) {
                doc = doctype.equalsIgnoreCase("html") ? new HTMLDocument(doc.getId()) : new XMLDocument(doc.getId());
                doc.enableLogging(super.getLog());
            }
        }
        this.getDocument(doc, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDocument(Document doc, OutputStream os) throws SDXException {
        super.getDocument(doc, os);
        Repository repo = null;
        RepositoryConnection conn = null;
        try {
            repo = this.getRepositoryForDocument(doc);
            if (repo != null) {
                conn = repo.getConnection();
            }
            if (repo != null && conn != null) {
                repo.get(doc, os, conn);
            }
            Object var6_5 = null;
            if (repo != null && conn != null) {
                repo.releaseConnection(conn);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (repo != null && conn != null) {
                repo.releaseConnection(conn);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getDocument(Document doc) throws SDXException {
        super.getDocument(doc);
        Repository repo = null;
        RepositoryConnection conn = null;
        InputStream is = null;
        try {
            repo = this.getRepositoryForDocument(doc);
            if (repo != null) {
                conn = repo.getConnection();
            }
            if (repo != null && conn != null) {
                is = repo.openStream(doc, null, conn);
            }
            Object var6_5 = null;
            if (repo != null && conn != null) {
                repo.releaseConnection(conn);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (repo != null && conn != null) {
                repo.releaseConnection(conn);
            }
            throw throwable;
        }
        return is;
    }

    protected Repository getRepositoryForStorage(Document doc, Repository defaultRepo) throws SDXException {
        String repoId;
        Repository repo = null;
        if (doc != null && Utilities.checkString(repoId = doc.getRepositoryForStorage())) {
            repo = this.getRepository(repoId);
        }
        if (repo == null) {
            repo = defaultRepo != null ? defaultRepo : this.defaultRepository;
        }
        return repo;
    }

    protected Repository getRepositoryForDocument(Document doc) throws SDXException {
        DatabaseEntity ent = null;
        String repoId = null;
        Repository repo = null;
        if (this.isUseMetadata()) {
            ent = this._database.getEntity(doc.getId());
            if (ent == null) {
                String[] args = new String[]{doc.getId(), this.getId()};
                throw new SDXException(super.getLog(), 2000, args, null);
            }
            ent.enableLogging(super.getLog());
            repoId = ent.getProperty("repo");
            if (Utilities.checkString(repoId) && this.repositories != null && this.repositories.containsKey(repoId)) {
                repo = (Repository)this.repositories.get(repoId);
            }
        } else {
            repo = this.defaultRepository;
        }
        return repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void delete(Document doc, boolean isIndexable, boolean isPrimary, boolean isShared, String relation, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        Utilities.checkDocument(super.getLog(), doc);
        Repository repository = null;
        if (handler != null) {
            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "deletion", "sdx:deletion", new AttributesImpl());
        }
        try {
            repository = this.getRepositoryForDocument(doc);
            if (isIndexable) {
                this.deleteIndexableDocumentComponents((IndexableDocument)doc, handler);
            }
            if (!isPrimary && isShared && Utilities.checkString(relation)) {
                this.deleteRelationsToMastersFromDatabase(relation, doc);
            }
            if (repository != null) {
                this.deletePhysicalDocument(doc, repository, handler);
            }
            if (this.isUseMetadata()) {
                this._database.delete(new DatabaseEntity(doc.getId()));
            }
            Object var9_8 = null;
            if (handler == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (handler == null) throw throwable;
            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "deletion", "sdx:deletion");
            throw throwable;
        }
        handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "deletion", "sdx:deletion");
    }

    protected void deleteIndexableDocumentComponents(IndexableDocument doc, ContentHandler handler) throws SDXException, ProcessingException, SAXException {
        DatabaseEntity ent = null;
        if (this.isUseMetadata()) {
            ent = this._database.getEntity(doc.getId());
        }
        if (this.isUseMetadata() && ent == null) {
            return;
        }
        IndexableDocument indexableDoc = doc;
        this.addOaiDeletedRecord(indexableDoc);
        this.deleteFromSearchIndex(indexableDoc.getId());
        DatabaseEntity originalDocEntry = null;
        String originalDocId = null;
        if (this.isUseMetadata()) {
            originalDocId = ent.getProperty("original");
        }
        if (this.isUseMetadata() && Utilities.checkString(originalDocId)) {
            originalDocEntry = this._database.getEntity(ent.getProperty("original"));
        }
        if (originalDocEntry != null) {
            BinaryDocument origDoc = new BinaryDocument();
            origDoc.enableLogging(super.getLog());
            origDoc.setId(originalDocEntry.getId());
            if (handler != null) {
                handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "original", "sdx:original", new AttributesImpl());
            }
            this.delete(origDoc, false, false, false, "original", handler);
            if (handler != null) {
                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "original", "sdx:original");
            }
        }
        Object attachedDocs = null;
        if (this.isUseMetadata()) {
            ent.getPropertyValues("attached");
        }
        if (attachedDocs != null && (attachedDocs).length > 0) {
            if (handler != null) {
                handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "attached", "sdx:attached", new AttributesImpl());
            }
            for (int i = 0; i < (attachedDocs).length; ++i) {
                if (this.isUseMetadata() && Utilities.checkString((String)attachedDocs[i])) {
                    DatabaseEntity l_attachedDocEntity = this._database.getEntity((String)attachedDocs[i]);
                    String[] l_attachedDocOwners = l_attachedDocEntity.getPropertyValues("parent");
                    if (l_attachedDocOwners == null || l_attachedDocOwners.length == 0) continue;
                    if (l_attachedDocOwners.length == 1 && l_attachedDocOwners[0] != null && l_attachedDocOwners[0].equals(indexableDoc.getId())) {
                        try {
                            BinaryDocument l_attachedDoc = new BinaryDocument();
                            l_attachedDoc.enableLogging(super.getLog());
                            l_attachedDoc.setId(l_attachedDocEntity.getId());
                            this.delete(l_attachedDoc, false, false, false, "attached", handler);
                        }
                        catch (SDXException e) {
                            if (handler == null) continue;
                            e.toSAX(handler);
                        }
                        catch (SAXException e) {
                            LoggingUtils.logError(super.getLog(), e.getMessage(), e);
                        }
                        catch (ProcessingException e) {
                            LoggingUtils.logError(super.getLog(), e.getMessage(), e);
                        }
                        continue;
                    }
                    if (l_attachedDocOwners.length == 1 && l_attachedDocOwners[0] != null && !l_attachedDocOwners[0].equals(indexableDoc.getId())) continue;
                    this._database.removeProperty(l_attachedDocEntity.getId(), "parent", indexableDoc.getId());
                    continue;
                }
                if (this.isUseMetadata() || !Utilities.checkString((String)attachedDocs[i])) continue;
                throw new SDXException("You must use metadata if you use attached documents");
            }
            if (handler != null) {
                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "attached", "sdx:attached");
            }
        }
        String[] subDocs = null;
        if (this.isUseMetadata()) {
            subDocs = ent.getPropertyValues("sub");
        }
        if (subDocs != null && subDocs.length > 0) {
            if (handler != null) {
                handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "sub", "sdx:sub", new AttributesImpl());
            }
            for (int i = 0; i < subDocs.length; ++i) {
                String[] l_subDocOwners;
                DatabaseEntity l_subDocEntity;
                if (!Utilities.checkString(subDocs[i]) || (l_subDocEntity = this._database.getEntity(subDocs[i])) == null || (l_subDocOwners = l_subDocEntity.getPropertyValues("parent")) == null || l_subDocOwners.length == 0) continue;
                if (l_subDocOwners.length == 1 && l_subDocOwners[0] != null && l_subDocOwners[0].equals(indexableDoc.getId())) {
                    try {
                        XMLDocument subDoc = new XMLDocument();
                        subDoc.enableLogging(super.getLog());
                        subDoc.setId(l_subDocEntity.getId());
                        this.delete(subDoc, true, false, false, "sub", handler);
                    }
                    catch (SDXException e) {
                        if (handler == null) continue;
                        e.toSAX(handler);
                    }
                    catch (SAXException e) {
                        LoggingUtils.logError(super.getLog(), e.getMessage(), e);
                    }
                    catch (ProcessingException e) {
                        LoggingUtils.logError(super.getLog(), e.getMessage(), e);
                    }
                    continue;
                }
                if (l_subDocOwners.length == 1 && l_subDocOwners[0] != null && !l_subDocOwners[0].equals(indexableDoc.getId())) continue;
                this._database.removeProperty(l_subDocEntity.getId(), "parent", indexableDoc.getId());
            }
            if (handler != null) {
                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "sub", "sdx:sub");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete(Document[] docs, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        if (docs != null) {
            block15: {
                long start = System.currentTimeMillis();
                AttributesImpl atts = new AttributesImpl();
                if (handler != null) {
                    String appId = Utilities.getStringFromContext("sdx.application.id", (Context)super.getContext());
                    if (Utilities.checkString(appId)) {
                        atts.addAttribute("", "app", "app", "CDATA", appId);
                    }
                    atts.addAttribute("", "base", "base", "CDATA", this.getId());
                    handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "deletions", "sdx:deletions", atts);
                }
                int deletions = 0;
                int failures = 0;
                try {
                    for (int i = 0; i < docs.length; ++i) {
                        try {
                            if (docs[i] instanceof IndexableDocument) {
                                this.delete(docs[i], true, false, true, null, handler);
                            } else if (docs[i] instanceof BinaryDocument) {
                                this.delete(docs[i], false, false, true, null, handler);
                            }
                            ++deletions;
                            continue;
                        }
                        catch (SDXException e) {
                            ++failures;
                            if (handler != null) {
                                e.toSAX(handler);
                                continue;
                            }
                            LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
                        }
                    }
                    Object var11_10 = null;
                    if (handler == null) break block15;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (handler != null) {
                        long finish = System.currentTimeMillis();
                        long elapsed = finish - start;
                        AttributesImpl summaryAtts = new AttributesImpl();
                        summaryAtts.addAttribute("", "deletions", "deletions", "CDATA", Integer.toString(deletions));
                        summaryAtts.addAttribute("", "failures", "failures", "CDATA", Integer.toString(failures));
                        summaryAtts.addAttribute("", "duration", "duration", "CDATA", String.valueOf(elapsed / 1000L));
                        handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary", summaryAtts);
                        handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary");
                        handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "deletions", "sdx:deletions");
                    }
                    if (this.autoOptimize) {
                        this.optimize();
                    }
                    throw throwable;
                }
                long finish = System.currentTimeMillis();
                long elapsed = finish - start;
                AttributesImpl summaryAtts = new AttributesImpl();
                summaryAtts.addAttribute("", "deletions", "deletions", "CDATA", Integer.toString(deletions));
                summaryAtts.addAttribute("", "failures", "failures", "CDATA", Integer.toString(failures));
                summaryAtts.addAttribute("", "duration", "duration", "CDATA", String.valueOf(elapsed / 1000L));
                handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary", summaryAtts);
                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary");
                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "deletions", "sdx:deletions");
            }
            if (this.autoOptimize) {
                this.optimize();
            }
        }
    }

    public synchronized void index(IndexableDocument doc, Repository repository, IndexParameters params, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        IndexableDocument[] docs = new IndexableDocument[]{doc};
        this.index(docs, repository, params, handler);
    }

    protected void rollbackIndexation(IndexableDocument doc, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        if (doc.getStoreHandler().getDocs().length > 0) {
            this.delete(doc.getStoreHandler().getDocs(), handler);
            this.deleteFromSearchIndex(doc.getId());
        }
    }

    public String[] getOwners(String relationType, String docId, ContentHandler handler) throws SDXException, SAXException {
        DatabaseEntity doc = null;
        if (this.isUseMetadata()) {
            doc = this._database.getEntity(docId);
        }
        if (doc == null) {
            String[] args = new String[]{docId, this.getId()};
            throw new SDXException(super.getLog(), 2000, args, null);
        }
        String[] owners = doc.getPropertyValues(relationType);
        if (handler != null && owners != null && owners.length > 0) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "no", "no", "CDATA", Integer.toString(owners.length));
            atts.addAttribute("", "relation", "relation", "CDATA", relationType);
            atts.addAttribute("", "id", "id", "CDATA", docId);
            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "owners", Utilities.prefixNodeNameSDX("owners"), atts);
            for (int i = 0; i < owners.length; ++i) {
                String ownerId = owners[i];
                if (ownerId == null || "".equals(ownerId)) continue;
                AttributesImpl atts2 = new AttributesImpl();
                atts2.addAttribute("", "id", "id", "CDATA", ownerId);
                handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "document", Utilities.prefixNodeNameSDX("document"), atts2);
                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "document", Utilities.prefixNodeNameSDX("document"));
            }
            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "owners", Utilities.prefixNodeNameSDX("owners"));
        }
        return owners;
    }

    public String[] getRelated(String docId, String relationType, ContentHandler handler) throws SDXException, SAXException {
        if (!Utilities.checkString(docId)) {
            return null;
        }
        DatabaseEntity doc = null;
        if (this.isUseMetadata()) {
            this._database.getEntity(docId);
        }
        if (doc == null) {
            String[] args = new String[]{docId, this.getId()};
            throw new SDXException(super.getLog(), 2000, args, null);
        }
        String[] related = doc.getPropertyValues(relationType);
        if (handler != null && related != null && related.length > 0) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "no", "no", "CDATA", Integer.toString(related.length));
            atts.addAttribute("", "relation", "relation", "CDATA", relationType);
            atts.addAttribute("", "id", "id", "CDATA", docId);
            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", relationType, Utilities.prefixNodeNameSDX(relationType), atts);
            for (int i = 0; i < related.length; ++i) {
                String relatedId = related[i];
                if (relatedId == null || "".equals(relatedId)) continue;
                AttributesImpl atts2 = new AttributesImpl();
                atts2.addAttribute("", "id", "id", "CDATA", relatedId);
                handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "document", Utilities.prefixNodeNameSDX("document"), atts2);
                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "document", Utilities.prefixNodeNameSDX("document"));
            }
            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", relationType, Utilities.prefixNodeNameSDX(relationType));
        }
        return related;
    }

    protected void deleteRelationsToMastersFromDatabase(String relation, Document doc) throws SDXException {
        String l_docId = doc.getId();
        if (this.isUseMetadata()) {
            this._database.removeProperty(relation, l_docId);
        }
    }

    protected synchronized int handleParameters(Document doc, Repository repo, IndexParameters params, boolean isIndexable, boolean isPrimary, String relation, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        String docId = doc.getId();
        Repository repoToUse = repo;
        Repository repoFromInternalLookup = null;
        boolean documentExistsInParamRepo = false;
        String repoIDFromInternalLookup = null;
        if (this.isUseMetadata()) {
            repoIDFromInternalLookup = this._database.getPropertyValue(docId, "repo");
        }
        if (Utilities.checkString(repoIDFromInternalLookup)) {
            repoFromInternalLookup = this.getRepository(repoIDFromInternalLookup);
        }
        if (repoToUse != null) {
            documentExistsInParamRepo = repoToUse.exists(docId, this.getPooledRepositoryConnection(repoToUse.getId()));
        }
        if (!documentExistsInParamRepo && repoFromInternalLookup != null) {
            repoToUse = repoFromInternalLookup;
        }
        int status = 2;
        int handleSameId = -1;
        handleSameId = isPrimary ? params.handleSameId() : (isIndexable ? params.handleSubDocumentSameId() : params.handleAttachedDocumentSameId());
        String repoToUseId = "";
        if (repoToUse != null) {
            repoToUseId = repoToUse.getId();
        }
        switch (handleSameId) {
            case 1: {
                status = 0;
                String[] args = new String[]{docId, super.getId(), repoToUseId};
                throw new SDXException(super.getLog(), 2003, args, null);
            }
            case 2: {
                LoggingUtils.logInfo(super.getLog(), "Ignoring document as another document with the same id exists: " + doc.getId());
                status = 1;
                break;
            }
            case 6: {
                if (isIndexable && Utilities.checkString(repoIDFromInternalLookup)) {
                    this.deleteIndexableDocumentComponents((IndexableDocument)doc, handler);
                }
                if (Utilities.checkString(repoIDFromInternalLookup) || documentExistsInParamRepo) {
                    this.deletePhysicalDocument(doc, repoToUse, handler);
                }
                status = 3;
                break;
            }
            default: {
                if (Utilities.checkString(repoIDFromInternalLookup)) {
                    boolean isShared = !isPrimary;
                    this.delete(doc, isIndexable, isPrimary, isShared, relation, handler);
                    status = 4;
                    break;
                }
                if (!isIndexable && !isPrimary && documentExistsInParamRepo) {
                    this.deletePhysicalDocument(doc, repoToUse, handler);
                    status = 2;
                    break;
                }
                if (this.isUseMetadata() && repoToUse != null) break;
                FieldQuery m_query = new FieldQuery();
                SearchLocations slocs = new SearchLocations();
                slocs.addDocumentBase(this);
                m_query.setUp(slocs, docId, "sdxdocid");
                m_query.prepare();
                Results res = m_query.execute();
                if (res != null && res.count() > 0) {
                    boolean isShared = !isPrimary;
                    this.delete(doc, isIndexable, isPrimary, isShared, relation, handler);
                    status = 4;
                }
                m_query = null;
                slocs = null;
            }
        }
        return status;
    }

    protected IndexParameters setBaseParameters(IndexParameters params) {
        User tmpUser;
        if (params == null) {
            params = new IndexParameters();
        }
        params.enableLogging(super.getLog());
        if (params.getPipelineParams() == null) {
            params.setPipelineParams(new Parameters());
        }
        if ((tmpUser = params.getUser()) != null) {
            params.getPipelineParams().setParameter("sdxUser", tmpUser.getId());
        }
        if (params.getPipeline() == null) {
            params.setPipeline(this._indexationPipeline);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void index(IndexableDocument[] docs, Repository repository, IndexParameters params, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        params = this.setBaseParameters(params);
        if (handler != null) {
            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "uploadDocuments", "sdx:uploadDocuments", new AttributesImpl());
        }
        long start = System.currentTimeMillis();
        boolean batchIndex = false;
        int docsAdded = 0;
        int docsFailed = 0;
        double batchMax = 0.0;
        int k = 0;
        if (docs != null && docs.length > 0) {
            TransformerHandler t;
            batchMax = params.getBatchMax();
            if (batchMax > (double)docs.length) {
                batchMax = docs.length;
            }
            int batches = (int)Math.ceil((double)docs.length / batchMax);
            int docIdx = 0;
            HashMap xml_field_list = this.getXMLFieldList();
            TransformerFactoryImpl tf = new TransformerFactoryImpl();
            try {
                t = tf.newTransformerHandler();
            }
            catch (TransformerConfigurationException e) {
                throw new SDXException("Can't create the parser of the xml fields before indexing.", e);
            }
            IndexableDocument current_doc = null;
            for (int i = 0; i < batches; ++i) {
                IOException e3;
                Object var27_28;
                batchIndex = true;
                if (docs.length == 1) {
                    batchIndex = false;
                }
                RepositoryConnection conn = null;
                if (repository == null) {
                    String[] args = new String[]{super.getId()};
                    SDXException sdxE = new SDXException(null, 2100, args, null);
                    LoggingUtils.logInfo(super.getLog(), sdxE.getMessage());
                    repository = this.defaultRepository;
                }
                if (repository != null && !Utilities.checkString(repository.getId())) {
                    throw new SDXException(super.getLog(), 2101, null, null);
                }
                try {
                    if (repository != null) {
                        conn = this.getPooledRepositoryConnection(repository.getId());
                    }
                    k = 1;
                    while (docIdx < docs.length && (double)k <= batchMax) {
                        Object var25_27;
                        current_doc = docs[docIdx];
                        try {
                            try {
                                if (current_doc == null) {
                                    throw new SDXException(super.getLog(), 5000, null, null);
                                }
                                current_doc.setXMLFieldList(xml_field_list);
                                current_doc.setXMLTransformerHandler(t);
                                t.getTransformer().setOutputProperty("encoding", "UTF-8");
                                this.index(current_doc, repository, conn, params, handler, batchIndex);
                                ++docsAdded;
                                docsAdded += current_doc.getStoreHandler().getDocs().length;
                            }
                            catch (SDXException e2) {
                                ++docsFailed;
                                if (handler != null && params.getSendIndexationEvents() >= 4) {
                                    AttributesImpl failAtts = new AttributesImpl();
                                    failAtts.addAttribute("", "status", "status", "CDATA", "failure");
                                    if (current_doc != null && current_doc.getId() != null) {
                                        failAtts.addAttribute("", "id", "id", "CDATA", current_doc.getId());
                                    }
                                    if (repository != null) {
                                        failAtts.addAttribute("", "repo", "repo", "CDATA", repository.getId());
                                    }
                                    failAtts.addAttribute("", "base", "base", "CDATA", this.getId());
                                    String appId = Utilities.getStringFromContext("sdx.application.id", (Context)super.getContext());
                                    if (Utilities.checkString(appId)) {
                                        failAtts.addAttribute("", "app", "app", "CDATA", appId);
                                    }
                                    handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "uploadDocument", "sdx:uploadDocument", failAtts);
                                    e2.toSAX(handler);
                                    handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "uploadDocument", "sdx:uploadDocument");
                                }
                                this.rollbackIndexation(current_doc, handler);
                                var25_27 = null;
                                docs[docIdx] = null;
                                ++docIdx;
                            }
                            var25_27 = null;
                            docs[docIdx] = null;
                            ++docIdx;
                        }
                        catch (Throwable throwable) {
                            var25_27 = null;
                            docs[docIdx] = null;
                            ++docIdx;
                            throw throwable;
                        }
                        ++k;
                    }
                    var27_28 = null;
                }
                catch (Throwable throwable) {
                    var27_28 = null;
                    try {
                        if (this.splitCheck(true)) {
                            this.splitIndex(true);
                        }
                        if (this.autoOptimize && batchIndex) {
                            this.mergeCurrentBatch();
                            this.optimize();
                        } else if (!this.autoOptimize) {
                            this.indexModified();
                        }
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (this.splitCheck(true)) {
                        this.splitIndex(true);
                    }
                    if (this.autoOptimize && batchIndex) {
                        this.mergeCurrentBatch();
                        this.optimize();
                        continue;
                    }
                    if (this.autoOptimize) continue;
                    this.indexModified();
                }
                catch (IOException e3) {}
            }
        }
        long finish = System.currentTimeMillis();
        long elapsed = finish - start;
        this.indexModified();
        try {
            if (this.splitCheck(false)) {
                this.splitIndex(false);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (handler != null && params.getSendIndexationEvents() >= 3) {
            AttributesImpl summaryAtts = new AttributesImpl();
            summaryAtts.addAttribute("", "additions", "additions", "CDATA", Integer.toString(docsAdded));
            summaryAtts.addAttribute("", "failures", "failures", "CDATA", Integer.toString(docsFailed));
            summaryAtts.addAttribute("", "duration", "duration", "CDATA", String.valueOf(elapsed / 1000L));
            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary", summaryAtts);
            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary");
        }
        if (handler != null) {
            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "uploadDocuments", "sdx:uploadDocuments");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void index(IndexableDocument doc, Repository repository, RepositoryConnection conn, IndexParameters params, ContentHandler handler, boolean batchIndex) throws SDXException, SAXException, ProcessingException {
        if (doc == null) {
            throw new SDXException(super.getLog(), 5000, null, null);
        }
        if (handler != null && params.getSendIndexationEvents() == 5) {
            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "uploadDocument", "sdx:uploadDocument", new AttributesImpl());
        }
        try {
            block14: {
                doc.enableLogging(super.getLog());
                doc.setIdGenerator(this.idGen);
                if (handler != null && params.getSendIndexationEvents() == 5) {
                    doc.setMessageHandler(handler);
                }
                URL tmpURL = doc.getURL();
                Parameters tmpParameters = params.getPipelineParams();
                String tempUrlString = "";
                if (tmpURL != null) {
                    tempUrlString = tmpURL.toExternalForm();
                }
                tmpParameters.setParameter("docUrl", tempUrlString);
                java.util.Date date = Date.getUtcIso8601Date();
                tmpParameters.setParameter("sdxDate", DateFormat.getDateTimeInstance(0, 0).format(date));
                tmpParameters.setParameter("sdxISO8601Date", Date.formatUtcISO8601Date(date));
                tmpParameters.setParameter("sdxDateMilliseconds", String.valueOf(date.getTime()));
                if (doc instanceof OAIDocument) {
                    tmpParameters.setParameter("sdxoaidate", ((OAIDocument)doc).getDateString());
                    tmpParameters.setParameter("sdxoaiid", ((OAIDocument)doc).getIdentifier());
                }
                Pipeline tmpPipeline = params.getPipeline();
                tmpPipeline.setParameters(tmpParameters);
                tmpPipeline.setConsumer(doc);
                SAXParser parser = null;
                try {
                    block13: {
                        try {
                            parser = (SAXParser)this._manager.lookup(SAXParser.ROLE);
                            doc.startIndexing(parser, (XMLConsumer)tmpPipeline);
                            byte[] tmpBytes = tmpPipeline.getTransformedBytes();
                            File tmpFile = tmpPipeline.getTransformedFile();
                            if (tmpBytes != null) {
                                doc.setTransformedDocument(tmpBytes);
                                break block13;
                            }
                            if (tmpFile != null) {
                                doc.setTransformedDocument(tmpFile);
                            }
                        }
                        catch (ServiceException e) {
                            String[] args = new String[]{e.getMessage()};
                            throw new SDXException(super.getLog(), 2001, args, e);
                        }
                    }
                    Object var16_17 = null;
                    if (parser == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    if (parser == null) throw throwable;
                    this._manager.release((Object)parser);
                    throw throwable;
                }
                this._manager.release((Object)parser);
            }
            this.add(batchIndex, doc, repository, conn, params, true, true, null, null, handler, null);
            Object var18_20 = null;
            if (handler == null) return;
            if (params.getSendIndexationEvents() != 5) return;
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            if (handler == null) throw throwable;
            if (params.getSendIndexationEvents() != 5) throw throwable;
            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "uploadDocument", "sdx:uploadDocument");
            throw throwable;
        }
        handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "uploadDocument", "sdx:uploadDocument");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void add(boolean batchIndex, Document originalDoc, Repository repository, RepositoryConnection conn, IndexParameters params, boolean isIndexable, boolean isPrimary, String relation, String parentId, ContentHandler handler, String attachedDocId) throws SDXException, SAXException, ProcessingException {
        Utilities.checkDocument(super.getLog(), originalDoc);
        Repository storeRepo = repository;
        RepositoryConnection storeRepoConn = conn;
        int status = -1;
        String repoId = "";
        status = this.handleParameters(originalDoc, repository, params, isIndexable, isPrimary, relation, handler);
        if (status < 2) {
            return;
        }
        if (handler != null && params.getSendIndexationEvents() == 5) {
            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "addition", "sdx:addition", new AttributesImpl());
        }
        try {
            if (storeRepo == null) {
                storeRepo = this.defaultRepository;
            }
            if ((storeRepo = this.getRepositoryForStorage(originalDoc, storeRepo)) != null) {
                repoId = storeRepo.getId();
            }
            if (storeRepo != null && (storeRepoConn == null || storeRepo != repository)) {
                storeRepoConn = this.getPooledRepositoryConnection(storeRepo.getId());
            }
            Document docToStore = originalDoc;
            String docToStoreId = "";
            boolean storeTransformed = false;
            DatabaseEntity docLookupEntry = null;
            String[] parentDocIds = new String[]{parentId};
            if (status == 3) {
                DatabaseEntity entityToRefresh = null;
                if (this.isUseMetadata()) {
                    entityToRefresh = this._database.getEntity(docToStore.getId());
                }
                if (entityToRefresh != null) {
                    String[] oldParents = entityToRefresh.getPropertyValues("parent");
                    parentDocIds = new String[oldParents.length + 1];
                    for (int i = 0; i < oldParents.length; ++i) {
                        parentDocIds[i + 1] = oldParents[i];
                    }
                }
            }
            if (attachedDocId != null) {
                docToStoreId = attachedDocId;
            }
            if (this.isUseMetadata()) {
                docLookupEntry = this.createEntityForDocMetaData(docToStore, storeRepo, parentDocIds);
            }
            if (isIndexable) {
                Object indexationDoc;
                block39: {
                    Enumeration subDocs;
                    block38: {
                        Enumeration attachedDocs;
                        block37: {
                            IndexableDocument transformedDoc = ((IndexableDocument)originalDoc).getTransformedDocument();
                            if (transformedDoc != null && !(storeRepo instanceof URLRepository) && Utilities.checkString(transformedDoc.getId())) {
                                originalDoc.setId("o_" + originalDoc.getId());
                                docToStore = transformedDoc;
                                storeTransformed = true;
                            }
                            docToStoreId = docToStore.getId();
                            if (storeTransformed && params.isSaveOriginalDocument() && this.keepOriginalDocuments) {
                                if (handler != null && params.getSendIndexationEvents() == 5) {
                                    handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "original", "sdx:original", new AttributesImpl());
                                }
                                try {
                                    this.add(batchIndex, originalDoc, repository, conn, params, false, false, "original", null, handler, null);
                                    ((IndexableDocument)docToStore).getStoreHandler().addDoc(originalDoc);
                                    if (this.isUseMetadata()) {
                                        docLookupEntry.addProperty("original", originalDoc.getId());
                                    }
                                    Object var25_26 = null;
                                    if (handler == null || params.getSendIndexationEvents() != 5) break block37;
                                }
                                catch (Throwable throwable) {
                                    Object var25_27 = null;
                                    if (handler == null) throw throwable;
                                    if (params.getSendIndexationEvents() != 5) throw throwable;
                                    handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "original", "sdx:original");
                                    throw throwable;
                                }
                                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "original", "sdx:original");
                            }
                        }
                        if ((attachedDocs = ((IndexableDocument)originalDoc).getAttachedDocuments()) != null) {
                            AttributesImpl summaryAtts2;
                            int attDocsAdded = 0;
                            boolean startElemSent = false;
                            try {
                                while (attachedDocs.hasMoreElements()) {
                                    if (attDocsAdded == 0 && handler != null && params.getSendIndexationEvents() == 5) {
                                        handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "attached", "sdx:attached", new AttributesImpl());
                                        startElemSent = true;
                                    }
                                    BinaryDocument attachedDoc = (BinaryDocument)attachedDocs.nextElement();
                                    this.add(batchIndex, attachedDoc, repository, conn, params, false, false, "attached", docToStoreId, handler, attachedDoc.getId());
                                    ++attDocsAdded;
                                    ((IndexableDocument)docToStore).getStoreHandler().addDoc(attachedDoc);
                                    if (!this.isUseMetadata()) continue;
                                    docLookupEntry.addProperty("attached", attachedDoc.getId());
                                }
                                Object var27_32 = null;
                                if (!startElemSent || handler == null || params.getSendIndexationEvents() != 5) break block38;
                                summaryAtts2 = new AttributesImpl();
                                summaryAtts2.addAttribute("", "additions", "additions", "CDATA", Integer.toString(attDocsAdded));
                            }
                            catch (Throwable throwable) {
                                Object var27_33 = null;
                                if (!startElemSent) throw throwable;
                                if (handler == null) throw throwable;
                                if (params.getSendIndexationEvents() != 5) throw throwable;
                                AttributesImpl summaryAtts2 = new AttributesImpl();
                                summaryAtts2.addAttribute("", "additions", "additions", "CDATA", Integer.toString(attDocsAdded));
                                handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary", summaryAtts2);
                                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary");
                                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "attached", "sdx:attached");
                                throw throwable;
                            }
                            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary", summaryAtts2);
                            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary");
                            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "attached", "sdx:attached");
                        }
                    }
                    if ((subDocs = ((IndexableDocument)originalDoc).getSubDocuments()) != null) {
                        AttributesImpl summaryAtts3;
                        int subDocsAdded = -1;
                        boolean startElemSent = false;
                        try {
                            while (subDocs.hasMoreElements()) {
                                if (subDocsAdded == 0 && handler != null && params.getSendIndexationEvents() == 5) {
                                    handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "sub", "sdx:sub", new AttributesImpl());
                                    startElemSent = true;
                                }
                                IndexableDocument subDoc = (IndexableDocument)subDocs.nextElement();
                                this.add(batchIndex, subDoc, repository, conn, params, true, false, "sub", docToStoreId, handler, null);
                                ++subDocsAdded;
                                ((IndexableDocument)docToStore).getStoreHandler().addDoc(subDoc);
                                if (!this.isUseMetadata()) continue;
                                docLookupEntry.addProperty("sub", subDoc.getId());
                            }
                            Object var30_38 = null;
                            if (!startElemSent || handler == null || params.getSendIndexationEvents() != 5) break block39;
                            summaryAtts3 = new AttributesImpl();
                            summaryAtts3.addAttribute("", "additions", "additions", "CDATA", Integer.toString(subDocsAdded));
                        }
                        catch (Throwable throwable) {
                            Object var30_39 = null;
                            if (!startElemSent) throw throwable;
                            if (handler == null) throw throwable;
                            if (params.getSendIndexationEvents() != 5) throw throwable;
                            AttributesImpl summaryAtts3 = new AttributesImpl();
                            summaryAtts3.addAttribute("", "additions", "additions", "CDATA", Integer.toString(subDocsAdded));
                            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary", summaryAtts3);
                            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary");
                            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "sub", "sdx:sub");
                            throw throwable;
                        }
                        handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary", summaryAtts3);
                        handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "summary", "sdx:summary");
                        handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "sub", "sdx:sub");
                    }
                }
                if ((indexationDoc = this.getIndexationDocument((IndexableDocument)originalDoc, docToStoreId, repoId, params)) != null) {
                    this.addToSearchIndex(indexationDoc, batchIndex);
                    this.removeOaiDeletedRecord((IndexableDocument)docToStore);
                }
            }
            if (storeRepo != null) {
                storeRepo.add(docToStore, storeRepoConn);
            }
            if (this.isUseMetadata()) {
                this._database.update(docLookupEntry);
            }
            if (handler != null && params.getSendIndexationEvents() == 5) {
                String length;
                String mimeType;
                AttributesImpl addAtts = new AttributesImpl();
                addAtts.addAttribute("", "status", "status", "CDATA", String.valueOf(_documentAdditionStatus[status]));
                addAtts.addAttribute("", "id", "id", "CDATA", docToStoreId);
                addAtts.addAttribute("", "repo", "repo", "CDATA", repoId);
                addAtts.addAttribute("", "base", "base", "CDATA", this.getId());
                String appId = Utilities.getStringFromContext("sdx.application.id", (Context)super.getContext());
                if (Utilities.checkString(appId)) {
                    addAtts.addAttribute("", "app", "app", "CDATA", appId);
                }
                if (Utilities.checkString(mimeType = docToStore.getMimeType())) {
                    addAtts.addAttribute("", "mimetype", "mimetype", "CDATA", mimeType);
                }
                if (Utilities.checkString(length = Integer.toString(docToStore.getLength()))) {
                    addAtts.addAttribute("", "byte-length", "byte-length", "CDATA", length);
                }
                handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "document", "sdx:document", addAtts);
                handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "document", "sdx:document");
            }
            Object var33_43 = null;
            if (handler == null) return;
            if (params.getSendIndexationEvents() != 5) return;
        }
        catch (Throwable throwable) {
            Object var33_44 = null;
            if (handler == null) throw throwable;
            if (params.getSendIndexationEvents() != 5) throw throwable;
            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "addition", "sdx:addition");
            throw throwable;
        }
        handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "addition", "sdx:addition");
    }

    public void init() throws SDXException {
        super.init();
        if (this.isUseMetadata()) {
            this.addParentRelationsToChildren();
        }
    }

    public abstract HashMap getXMLFieldList();

    private void addParentRelationsToChildren() throws SDXException {
        final Logger l_finalLogger = super.getLog();
        if (this.isUseMetadata()) {
            new Thread(){

                public void run() {
                    try {
                        DatabaseEntity dbFormat = SDXDocumentBase.this._database.getEntity(SDXDocumentBase.SDX_DATABASE_FORMAT);
                        if (dbFormat != null && dbFormat.containsValue(SDXDocumentBase.SDX_DATABASE_VERSION, SDXDocumentBase.SDX_DATABASE_VERSION_2_3)) {
                            return;
                        }
                        Parameters l_attachedDocParams = new Parameters();
                        l_attachedDocParams.setParameter("attached", SDXDocumentBase.this._database.getWildcardSearchToken());
                        String[] l_attachedDocParents = SDXDocumentBase.this._database.search(l_attachedDocParams);
                        for (int i = 0; i < l_attachedDocParents.length; ++i) {
                            DatabaseEntity l_entity = SDXDocumentBase.this._database.getEntity(l_attachedDocParents[i]);
                            String l_entityId = l_entity.getId();
                            String[] l_attachedDocsIds = l_entity.getPropertyValues("attached");
                            for (int j = 0; j < l_attachedDocsIds.length; ++j) {
                                String l_attachedDocId = l_attachedDocsIds[j];
                                DatabaseEntity l_attachedDoc = SDXDocumentBase.this._database.getEntity(l_attachedDocId);
                                if (l_attachedDoc == null || !l_attachedDoc.containsValue("parent", l_entityId)) continue;
                                SDXDocumentBase.this._database.addProperty(l_attachedDocId, "parent", l_entityId);
                            }
                        }
                        Parameters l_subDocParams = new Parameters();
                        l_attachedDocParams.setParameter("sub", SDXDocumentBase.this._database.getWildcardSearchToken());
                        String[] l_subDocParents = SDXDocumentBase.this._database.search(l_subDocParams);
                        for (int i = 0; i < l_subDocParents.length; ++i) {
                            DatabaseEntity l_entity = SDXDocumentBase.this._database.getEntity(l_subDocParents[i]);
                            String l_entityId = l_entity.getId();
                            String[] l_subDocsIds = l_entity.getPropertyValues("sub");
                            for (int j = 0; j < l_subDocsIds.length; ++j) {
                                String l_subDocId = l_subDocsIds[j];
                                DatabaseEntity l_subDoc = SDXDocumentBase.this._database.getEntity(l_subDocId);
                                if (l_subDoc == null || !l_subDoc.containsValue("parent", l_entityId)) continue;
                                SDXDocumentBase.this._database.addProperty(l_subDocId, "parent", l_entityId);
                            }
                        }
                        DatabaseEntity dbe = new DatabaseEntity(SDXDocumentBase.SDX_DATABASE_FORMAT);
                        dbe.addProperty(SDXDocumentBase.SDX_DATABASE_VERSION, SDXDocumentBase.SDX_DATABASE_VERSION_2_3);
                        SDXDocumentBase.this._database.save(dbe);
                    }
                    catch (SDXException e) {
                        l_finalLogger.error(e.getMessage(), (Throwable)((Object)e));
                    }
                }
            }.start();
        }
    }

    protected boolean initToSax() {
        if (!super.initToSax()) {
            return false;
        }
        this._xmlizable_objects.put("Auto_Optimize", String.valueOf(this.autoOptimize));
        this._xmlizable_objects.put("Split_Size", String.valueOf(this.getSplitSize()));
        this._xmlizable_objects.put("Split_Unit", String.valueOf(this.splitUnit));
        this._xmlizable_objects.put("Split_Doc", String.valueOf(this.splitDoc));
        this._xmlizable_objects.put("Keep_Original_Documents", String.valueOf(this.keepOriginalDocuments));
        if (this.isUseMetadata()) {
            this._xmlizable_objects.put("SDX_DocumentBase_DataBase", this._database);
        }
        this._xmlizable_objects.put("SDX_DocumentBase_Repositories", this.repositories);
        this._xmlizable_objects.put("SDX_OAI_Harvester", this._oaiHarv);
        return true;
    }

    protected void initVolatileObjectsToSax() {
        super.initVolatileObjectsToSax();
        this._xmlizable_objects.put("Auto_Optimize", String.valueOf(this.autoOptimize));
        this._xmlizable_objects.put("Split_Size", String.valueOf(this.getSplitSize()));
        this._xmlizable_objects.put("Split_Unit", String.valueOf(this.splitUnit));
        this._xmlizable_objects.put("Split_Doc", String.valueOf(this.splitDoc));
        this._xmlizable_objects.put("Keep_Original_Documents", String.valueOf(this.keepOriginalDocuments));
        this._xmlizable_objects.put("UseMetadata", String.valueOf(this.isUseMetadata()));
    }

    public abstract void optimize();

    public abstract void mergeBatch() throws SDXException;

    public abstract void mergeCurrentBatch();

    public abstract void indexModified();

    public abstract boolean splitCheck(boolean var1) throws SDXException;

    public abstract void splitIndex(boolean var1) throws IOException, SDXException;

    public final boolean isIndexOptimized() {
        return this._isIndexOptimized;
    }

    protected void configureOptimizeTriggers(Configuration optimizeConf) throws ConfigurationException {
        if (optimizeConf == null || this.autoOptimize) {
            return;
        }
        TimeTrigger trigger = new TimeTriggerFactory().createTimeTrigger(optimizeConf);
        if (trigger == null) {
            return;
        }
        if (this.scheduler == null) {
            this.scheduler = new SimpleTimeScheduler();
        }
        if (this.scheduler != null) {
            this.scheduler.addTrigger("optimization", trigger, this);
            this.scheduler.start();
        }
    }

    public void targetTriggered(String triggeredString) {
        if (triggeredString.equalsIgnoreCase("optimization")) {
            this.optimize();
        }
    }

    public void checkIntegrity() {
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null) {
            String db_path = save_config.getUniqueIDString() + "_db";
            if (save_config.isAllElementSelected()) {
                File db_dir = new File(save_config.getStoreCompletePath() + File.separator + db_path);
                if (!db_dir.exists()) {
                    db_dir.mkdir();
                }
                save_config.savePathInConfig(db_path);
                SaveParameters saveparams = new SaveParameters(Utilities.getElementName("Database"), save_config, db_path);
                if (this.isUseMetadata()) {
                    this._database.backup(saveparams);
                }
                if (this.repositories != null && this.repositories.size() > 0) {
                    saveparams = new SaveParameters(Utilities.getElementName("repositories"), save_config, db_path);
                    this.backupRepositories(saveparams);
                }
                SaveParameters indexes_save = new SaveParameters(Utilities.getElementName("Index") + "es", save_config, db_path);
                this.backupIndexes(indexes_save);
                SaveParameters timeStamp_save = new SaveParameters("timestamps", indexes_save);
                this.backupTimeStamp(timeStamp_save);
            }
        }
    }

    protected abstract void backupIndexes(SaveParameters var1) throws SDXException;

    protected abstract void backupTimeStamp(SaveParameters var1) throws SDXException;

    private void backupRepositories(SaveParameters save_config) throws SDXException {
        if (this.repositories != null && this.repositories.size() > 0) {
            String repos_path = "repositories";
            File repos_dir = new File(save_config.getStoreCompletePath() + File.separator + repos_path);
            if (!repos_dir.exists()) {
                repos_dir.mkdir();
            }
            Enumeration enumeration = this.repositories.elements();
            while (enumeration.hasMoreElements()) {
                Repository repo = (Repository)enumeration.nextElement();
                if (repo == null) continue;
                SaveParameters reposave = new SaveParameters(Utilities.getElementName("Repository"), save_config, repos_path);
                reposave.setUniqueID(save_config.getUniqueID());
                repo.backup(reposave);
            }
        }
    }

    public void restore(SaveParameters save_config) throws SDXException {
        super.restore(save_config);
        if (save_config != null && save_config.isAllElementSelected()) {
            SaveParameters saveparams = (SaveParameters)save_config.getChild(Utilities.getElementName("Database"));
            if (this.isUseMetadata()) {
                this._database.restore(saveparams);
            }
            if (this.repositories != null && this.repositories.size() > 0) {
                saveparams = (SaveParameters)save_config.getChild(Utilities.getElementName("repositories"));
                this.restoreRepositories(saveparams);
            }
            SaveParameters indexes_save = (SaveParameters)save_config.getChild(Utilities.getElementName("Index") + "es");
            this.restoreIndexes(indexes_save);
            SaveParameters timeStamp_save = (SaveParameters)indexes_save.getChild("timestamps");
            this.restoreTimeStamp(timeStamp_save);
        }
    }

    private void restoreRepositories(SaveParameters save_config) throws SDXException {
        if (this.repositories != null && this.repositories.size() > 0) {
            Enumeration enumeration = this.repositories.elements();
            while (enumeration.hasMoreElements()) {
                Repository repo = (Repository)enumeration.nextElement();
                if (repo == null) continue;
                SaveParameters reposave = save_config.getSaveParametersById(repo.getId());
                repo.restore(reposave);
            }
        }
    }

    protected abstract void restoreIndexes(SaveParameters var1) throws SDXException;

    protected abstract void restoreTimeStamp(SaveParameters var1) throws SDXException;

    public void close() {
        super.close();
    }
}

