/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.OAIMetadataFormat;
import fr.gouv.culture.oai.OAIObjectImpl;
import fr.gouv.culture.oai.util.OAIUtilities;
import org.apache.avalon.framework.parameters.Parameters;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractOAIMetadataFormat
extends OAIObjectImpl
implements OAIMetadataFormat {
    protected String formatName = "";
    protected String prefix = "";
    protected String schemaUrl = "";
    protected String namespace = "";
    protected String rootElement = "";
    protected Parameters metadataMappings = null;

    public String getName() {
        return this.formatName;
    }

    public void setName(String formatName) {
        this.formatName = formatName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSchemaUrl() {
        return this.schemaUrl;
    }

    public void setSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Parameters getMappings() {
        return this.metadataMappings;
    }

    public void setMappings(Parameters mappings) {
        this.metadataMappings = mappings;
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        if (OAIUtilities.checkString(this.prefix) && OAIUtilities.checkString(this.schemaUrl) && OAIUtilities.checkString(this.namespace)) {
            ContentHandler currentHandler = this.contentHandler;
            super.setContentHandler(contentHandler);
            String oai20xmlns = "http://www.openarchives.org/OAI/2.0/";
            super.startElement(oai20xmlns, "metadataFormat", "metadataFormat", null);
            super.sendElement(oai20xmlns, "metadataPrefix", "metadataPrefix", null, this.prefix);
            super.sendElement(oai20xmlns, "schema", "schema", null, this.schemaUrl);
            super.sendElement(oai20xmlns, "metadataNamespace", "metadataNamespace", null, this.namespace);
            super.endElement(oai20xmlns, "metadataFormat", "metadataFormat");
            super.setContentHandler(currentHandler);
        }
    }

    public void startMetadataFormatRootElement() throws SAXException {
        String elemName = null;
        String qName = null;
        String uri = this.namespace;
        if (OAIUtilities.checkString(this.prefix) && OAIUtilities.checkString(this.namespace) && OAIUtilities.checkString(this.schemaUrl)) {
            elemName = this.rootElement;
            qName = this.prefix + ":" + elemName;
            AttributesImpl atts = new AttributesImpl();
            if (this.prefix.equals("oai_dc")) {
                elemName = "dc";
                qName = "oai_dc:dc";
                uri = "http://www.openarchives.org/OAI/2.0/oai_dc/";
                super.startPrefixMapping("dc", "http://purl.org/dc/elements/1.1/");
            }
            super.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            super.startPrefixMapping(this.prefix, uri);
            String schemaLocVal = uri + " " + this.schemaUrl;
            if (atts.getIndex("xsi:schemaLocation") < 0) {
                atts.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "xsi:schemaLocation", "CDATA", schemaLocVal);
            }
            super.startElement(uri, elemName, qName, atts);
        }
    }

    public void endMetadataFormatRootElement() throws SAXException {
        String elemName = null;
        String qName = null;
        String uri = "";
        if (OAIUtilities.checkString(this.prefix)) {
            elemName = this.prefix;
            qName = this.prefix + ":" + elemName;
            if (this.prefix.equals("oai_dc")) {
                uri = "http://www.openarchives.org/OAI/2.0/oai_dc/";
                elemName = "dc";
                qName = "oai_dc:dc";
            }
            super.endElement(uri, elemName, qName);
            super.endPrefixMapping(elemName);
            super.endPrefixMapping("xsi");
        }
    }

    protected void prepareAndSendElement(String origName, String value) throws SAXException {
        if (OAIUtilities.checkString(this.namespace) && OAIUtilities.checkString(this.prefix) && OAIUtilities.checkString(origName) && OAIUtilities.checkString(value)) {
            String uri = this.namespace;
            String locName = null;
            if (this.metadataMappings != null && this.metadataMappings.isParameter(origName)) {
                locName = this.metadataMappings.getParameter(origName, null);
            }
            if (OAIUtilities.checkString(locName)) {
                String qName = locName;
                String tmpPrefix = this.prefix;
                if (tmpPrefix.equals("oai_dc")) {
                    qName = "dc:" + locName;
                }
                super.sendElement(uri, locName, qName, new AttributesImpl(), value);
            }
        }
    }

    public void sendElement(String origName, String value) throws SAXException {
        if (OAIUtilities.checkString(origName) && OAIUtilities.checkString(value)) {
            this.prepareAndSendElement(origName, value);
        }
    }
}

