/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.queryparser;

import fr.gouv.culture.sdx.search.lucene.queryparser.DefaultQueryParser;
import fr.gouv.culture.sdx.search.lucene.queryparser.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ZeroPositionIncrementTokenQueryParser
extends DefaultQueryParser {
    protected Query getFieldQuery(String field, Analyzer analyzer, String queryText) throws ParseException {
        Token t;
        TokenStream source = analyzer.tokenStream(field, (Reader)new StringReader(queryText));
        Vector<Token> v = new Vector<Token>();
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        while (true) {
            try {
                t = source.next();
            }
            catch (IOException e) {
                t = null;
            }
            if (t == null) break;
            v.addElement(t);
            if (t.getPositionIncrement() == 1) {
                ++positionCount;
                continue;
            }
            severalTokensAtSamePosition = true;
        }
        if (v.size() == 0) {
            return null;
        }
        if (v.size() == 1) {
            t = (Token)v.elementAt(0);
            return new TermQuery(new Term(field, t.termText()));
        }
        if (severalTokensAtSamePosition) {
            PhraseQuery currentQuery;
            int i;
            if (positionCount == 1) {
                BooleanQuery q = new BooleanQuery();
                for (int i2 = 0; i2 < v.size(); ++i2) {
                    t = (Token)v.elementAt(i2);
                    TermQuery currentQuery2 = new TermQuery(new Term(field, t.termText()));
                    q.add((Query)currentQuery2, false, false);
                }
                return q;
            }
            BooleanQuery q = new BooleanQuery();
            Vector queriesSoFar = new Vector();
            Vector<PhraseQuery> newQueries = new Vector<PhraseQuery>();
            int currentPosition = 0;
            for (i = 0; i < v.size(); ++i) {
                int j;
                t = (Token)v.elementAt(i);
                if (t.getPositionIncrement() == 1) {
                    queriesSoFar.removeAllElements();
                    for (j = 0; j < newQueries.size(); ++j) {
                        queriesSoFar.add(newQueries.elementAt(j));
                    }
                    newQueries.removeAllElements();
                    ++currentPosition;
                }
                if (currentPosition == 1) {
                    currentQuery = new PhraseQuery();
                    currentQuery.setSlop(this.phraseSlop);
                    currentQuery.add(new Term(field, t.termText()));
                    newQueries.add(currentQuery);
                    continue;
                }
                for (j = 0; j < queriesSoFar.size(); ++j) {
                    PhraseQuery previousQuery = (PhraseQuery)queriesSoFar.elementAt(j);
                    Term[] terms = previousQuery.getTerms();
                    currentQuery = new PhraseQuery();
                    currentQuery.setSlop(this.phraseSlop);
                    for (int k = 0; k < terms.length; ++k) {
                        currentQuery.add(terms[k]);
                    }
                    currentQuery.add(new Term(field, t.termText()));
                    newQueries.add(currentQuery);
                }
            }
            for (i = 0; i < newQueries.size(); ++i) {
                currentQuery = (PhraseQuery)newQueries.elementAt(i);
                q.add((Query)currentQuery, false, false);
            }
            return q;
        }
        PhraseQuery q = new PhraseQuery();
        q.setSlop(this.phraseSlop);
        for (int i = 0; i < v.size(); ++i) {
            q.add(new Term(field, ((Token)v.elementAt(i)).termText()));
        }
        return q;
    }
}

