/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.documentbase.LuceneIndexParameters;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.FieldsDefinition;
import fr.gouv.culture.sdx.search.lucene.analysis.MetaAnalyzer;
import fr.gouv.culture.sdx.search.lucene.query.Index;
import fr.gouv.culture.sdx.search.lucene.query.RemoteIndex;
import fr.gouv.culture.sdx.search.lucene.queryparser.QueryParser;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.lucene.LuceneDataStore;
import java.io.File;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Locale;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class LuceneIndex
extends LuceneDataStore
implements Configurable,
Index {
    private FieldsDefinition fields = null;
    private RAMDirectory tempBatch = null;
    private MetaAnalyzer metaAnalyzer = null;
    private final String ATTRIBUTE_CLASS = "class";
    private Class queryParserClass = null;
    private final String DEFAULT_QUERYPARSER = "fr.gouv.culture.sdx.search.lucene.queryparser.DefaultQueryParser";
    private final String ELEMENT_NAME_QUERYPARSER = "queryParser";
    private String remoteIndexName = "";
    private int rmiPort;
    private String rmiHost = "";
    protected Date creationTimestamp = null;
    protected Date lastModificationTimestamp = null;
    public static final int ACTION_ADD_DOCUMENT = 1;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    private int maxFieldLength = 10000;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    private final String ATTRIBUTE_MAX_FIELD_LENGTH = "maxFieldLength";

    public LuceneIndex(File dir, String host, Integer port, String appId, String dbId) throws SDXException {
        super(dir);
        if (Utilities.checkString(host)) {
            this.rmiHost = host;
        }
        this.rmiPort = port != null ? port : 9000;
        if (Utilities.checkString(appId) && Utilities.checkString(dbId)) {
            this.remoteIndexName = Utilities.buildRmiName(this.rmiHost, this.rmiPort, appId, dbId);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configureQueryParser(configuration);
        boolean remoteConf = configuration.getAttributeAsBoolean("remote-access", false);
        if (!remoteConf) {
            this.remoteIndexName = null;
        }
        if (remoteConf) {
            try {
                this.bindRemoteObjectToRegistry(this.remoteIndexName, new RemoteIndex(this));
            }
            catch (SDXException sdxE) {
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
            }
            catch (RemoteException e) {
                throw new ConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
        this.maxFieldLength = configuration.getAttributeAsInteger("maxFieldLength", 10000);
    }

    private void configureQueryParser(Configuration configuration) throws ConfigurationException {
        Configuration qpConf = configuration.getChild("queryParser", false);
        String qpClassName = "fr.gouv.culture.sdx.search.lucene.queryparser.DefaultQueryParser";
        if (qpConf != null) {
            qpClassName = qpConf.getAttribute("class", "fr.gouv.culture.sdx.search.lucene.queryparser.DefaultQueryParser");
        }
        try {
            this.queryParserClass = Class.forName(qpClassName);
        }
        catch (ClassNotFoundException e) {
            SDXException sdxE = new SDXException(this.logger, 37, null, e);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
        }
    }

    private void bindRemoteObjectToRegistry(String name, Remote obj) throws SDXException {
        try {
            Naming.rebind(name, obj);
        }
        catch (IOException e) {
            String[] args = new String[]{name};
            throw new SDXException(this.logger, 38, args, e);
        }
    }

    public void init() throws SDXException {
        super.init(false);
        this.writeCreationTimestampFile();
        this.writeLastModificationTimestampFile(false);
        if (this.metaAnalyzer == null) {
            throw new SDXException(this.logger, 4102, null, null);
        }
    }

    protected void writeCreationTimestampFile() {
        try {
            File createFile = new File(this.fsdFile.getParentFile(), "creation-timestamp");
            if (!createFile.exists()) {
                createFile.createNewFile();
            }
            this.creationTimestamp = new Date(createFile.lastModified());
        }
        catch (IOException e) {
            Utilities.logError(this.logger, e.getMessage(), e);
        }
    }

    public void writeLastModificationTimestampFile(boolean create) {
        try {
            File lastModFile = new File(this.fsdFile.getParentFile(), "last-modification-timestamp");
            if (create) {
                lastModFile.delete();
                lastModFile.createNewFile();
            } else if (!lastModFile.exists()) {
                lastModFile.createNewFile();
            }
            this.lastModificationTimestamp = new Date(lastModFile.lastModified());
        }
        catch (IOException e) {
            Utilities.logError(this.logger, e.getMessage(), e);
        }
    }

    public int getFieldType(String name) {
        return this.fields.getFieldType(name);
    }

    public Locale getLocale(String name) {
        return this.fields.getLocale(name);
    }

    public Field getDefaultField() {
        return this.fields.getDefaultField();
    }

    public Field getField(String name) {
        return this.fields.getField(name);
    }

    public FieldsDefinition getFieldsDefinition() {
        return this.fields;
    }

    public Searchable getSearcher() {
        return super.getSearcher();
    }

    public MetaAnalyzer getMetaAnalyzer() {
        return this.metaAnalyzer;
    }

    public void setMetaAnalyzer(MetaAnalyzer mAnalyzer) throws SDXException {
        this.metaAnalyzer = mAnalyzer;
        this.fields = this.metaAnalyzer.getFieldsDefinition();
        this.analyzer = this.metaAnalyzer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void writeDocument(Document ldoc, boolean batchIndex) throws SDXException {
        IndexWriter w = null;
        try {
            try {
                if (batchIndex && this.tempBatch == null) {
                    this.tempBatch = new RAMDirectory();
                    IndexWriter initTempBatch = new IndexWriter((Directory)this.tempBatch, (Analyzer)this.getMetaAnalyzer(), true);
                    initTempBatch.close();
                }
                if (this.tempBatch != null && (w = this.getWriter((Directory)this.tempBatch)) != null) {
                    w.addDocument(ldoc);
                    w.close();
                    w = null;
                }
            }
            catch (IOException e) {
                String[] args = new String[]{super.getIndexPath(), e.getMessage()};
                throw new SDXException(this.logger, 204, args, e);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (w == null) throw throwable;
                w.close();
                throw throwable;
            }
            catch (IOException e) {
                String[] args = new String[]{super.getIndexPath(), e.getMessage()};
                throw new SDXException(this.logger, 204, args, e);
            }
        }
        try {}
        catch (IOException e) {
            String[] args = new String[]{super.getIndexPath(), e.getMessage()};
            throw new SDXException(this.logger, 204, args, e);
        }
        if (w != null) {
            w.close();
        }
        if (batchIndex) return;
        if (this.tempBatch != null) return;
        super.write(ldoc);
        this.writeLastModificationTimestampFile(true);
    }

    public synchronized void deleteDocument(String docId) throws SDXException {
        super.delete(docId);
    }

    public QueryParser getQueryParser() throws IOException, SDXException {
        try {
            if (this.queryParserClass == null) {
                return null;
            }
            return (QueryParser)this.queryParserClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SDXException(this.logger, 4110, null, e);
        }
        catch (IllegalAccessException e) {
            throw new SDXException(this.logger, 4110, null, e);
        }
    }

    public String getRemoteIndexName() {
        return this.remoteIndexName;
    }

    public synchronized void mergeBatch() throws SDXException {
        try {
            block6: {
                try {
                    if (this.tempBatch != null) {
                        File tmpDir = new File(this.fsdFile.getParent(), "tmp");
                        tmpDir.mkdirs();
                        File tmpOldDir = File.createTempFile("old", "Index", tmpDir);
                        tmpOldDir.delete();
                        File tmpNewDir = File.createTempFile("new", "Index", tmpDir);
                        tmpNewDir.delete();
                        Directory[] dirs = new Directory[]{this.fsd, this.tempBatch};
                        Utilities.checkDirectory(tmpNewDir.getAbsolutePath(), this.logger);
                        FSDirectory tempNewLuceneDir = FSDirectory.getDirectory((File)tmpNewDir, (boolean)true);
                        IndexWriter w = new IndexWriter((Directory)tempNewLuceneDir, (Analyzer)this.getMetaAnalyzer(), true);
                        w.addIndexes(dirs);
                        w.close();
                        this.freeResources();
                        this.fsdFile.renameTo(tmpOldDir);
                        tmpNewDir.renameTo(this.fsdFile);
                        File[] files = tmpOldDir.listFiles();
                        for (int i = 0; files != null && i < files.length; ++i) {
                            files[i].delete();
                        }
                        tmpOldDir.delete();
                        tmpOldDir.getParentFile().delete();
                        break block6;
                    }
                    this.optimize();
                }
                catch (IOException e) {
                    String[] args = new String[]{super.getIndexPath(), e.getMessage()};
                    throw new SDXException(this.logger, 204, args, e);
                }
            }
            Object var10_11 = null;
            this.tempBatch = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.tempBatch = null;
            super.init(false);
            this.writeLastModificationTimestampFile(true);
            throw throwable;
        }
        super.init(false);
        this.writeLastModificationTimestampFile(true);
    }

    protected void freeResources() throws IOException {
        super.freeResources();
        if (this.tempBatch != null) {
            this.tempBatch.close();
        }
    }

    protected synchronized IndexWriter getWriter(Directory directory) throws IOException {
        IndexWriter w = super.getWriter(directory);
        if (this.maxFieldLength != 10000) {
            w.maxFieldLength = this.maxFieldLength;
        }
        if (this.maxMergeDocs != Integer.MAX_VALUE) {
            w.maxMergeDocs = this.maxMergeDocs;
        }
        if (this.mergeFactor != 10) {
            w.mergeFactor = this.mergeFactor;
        }
        return w;
    }

    public void setParameters(LuceneIndexParameters params) {
        this.maxMergeDocs = params.getMaxMergeDocs();
        this.mergeFactor = params.getMergeFactor();
    }

    public synchronized void optimize() throws SDXException {
        super.optimize();
    }

    public synchronized IndexReader getReader() throws SDXException {
        return super.getReader();
    }

    public String getFieldValue(IndexableDocument doc, String fieldName) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        if (!Utilities.checkString(fieldName)) {
            return null;
        }
        Hits h = this.search((Query)new TermQuery(new Term("sdxdocid", doc.getId())));
        if (h.length() == 1) {
            try {
                org.apache.lucene.document.Field field = h.doc(0).getField(fieldName);
                if (field != null) {
                    return field.stringValue();
                }
                return null;
            }
            catch (IOException e) {
                String[] args = new String[]{this.fsd.toString(), e.getMessage()};
                throw new SDXException(this.logger, 201, args, e);
            }
        }
        return null;
    }

    public Date getCreationDate() {
        return this.creationTimestamp;
    }

    public Date getLastModificationDate() {
        return this.lastModificationTimestamp;
    }
}

