/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.pipeline.AbstractTransformation;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.xml.SimpleXPathString;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TagFilter
extends AbstractTransformation {
    protected boolean _send = false;
    protected String lastPrefixRemoved = null;
    protected String c_uri = "";
    protected String c_loc = "";
    protected String c_raw = "";
    protected Attributes c_atts = null;
    protected SimpleXPathString _xpathString = new SimpleXPathString();

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.setSendMode(this.transParameters);
    }

    protected void setSendMode(Parameters params) {
        if (params != null) {
            this._send = params.getParameterAsBoolean("send", this._send);
        }
    }

    protected void setCurrentElementProperties(String uri, String loc, String raw, Attributes atts) {
        this.c_uri = uri;
        this.c_loc = loc;
        this.c_raw = raw;
        this.c_atts = atts;
        if (Utilities.checkString(this.c_loc)) {
            this._xpathString.concatLocalXPath(this.c_loc);
        }
        if (Utilities.checkString(this.c_raw)) {
            this._xpathString.concatQualifiedXPath(this.c_raw);
        }
    }

    protected void resetCurrentElementProperties() {
        this._xpathString.trimLocalXPath(this.c_loc);
        this._xpathString.trimQualifiedXPath(this.c_raw);
        this.setCurrentElementProperties("", "", "", null);
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.setCurrentElementProperties(uri, loc, raw, a);
        if (this.shouldSendElementEvent(uri, loc, raw, a)) {
            super.startElement(uri, loc, raw, a);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (this.shouldSendElementEvent(uri, loc, raw, this.c_atts)) {
            super.endElement(uri, loc, raw);
        }
        this.resetCurrentElementProperties();
    }

    protected boolean shouldSendElementEvent(String uri, String loc, String raw, Attributes a) {
        boolean send;
        boolean bl = send = !this._send;
        if (this.transParameters != null && (loc != null || uri != null)) {
            String mappedUri = "";
            String prefix = "";
            int colonIdx = raw.indexOf(":");
            if (colonIdx < 0) {
                colonIdx = raw.length();
            }
            prefix = raw.substring(0, colonIdx);
            if (this.transParameters.isParameter(loc)) {
                send = this._send;
                if (Utilities.checkString(mappedUri = this.transParameters.getParameter(loc, mappedUri)) && !uri.equals(mappedUri)) {
                    send = !this._send;
                }
            } else if (this.transParameters.isParameter(raw)) {
                send = this._send;
                if (Utilities.checkString(mappedUri = this.transParameters.getParameter(raw, mappedUri)) && !uri.equals(mappedUri)) {
                    send = !this._send;
                }
            } else if (this.transParameters.isParameter(this._xpathString.getLocalXPath())) {
                send = this._send;
                mappedUri = this.transParameters.getParameter(this._xpathString.getLocalXPath(), mappedUri);
                if (Utilities.checkString(mappedUri) && !uri.equals(mappedUri)) {
                    send = !this._send;
                }
            } else if (this.transParameters.isParameter(this._xpathString.getQualifiedXPath())) {
                send = this._send;
                mappedUri = this.transParameters.getParameter(this._xpathString.getQualifiedXPath(), mappedUri);
                if (Utilities.checkString(mappedUri) && !uri.equals(mappedUri)) {
                    send = !this._send;
                }
            } else if (this.transParameters.isParameter(prefix)) {
                send = this._send;
                mappedUri = this.transParameters.getParameter(prefix, "");
                if (Utilities.checkString(mappedUri) && !uri.equals(mappedUri)) {
                    send = !this._send;
                }
            } else if (this.transParameters.isParameter(uri)) {
                send = this._send;
                String mappedPrefix = this.transParameters.getParameter(uri, "");
                if (Utilities.checkString(mappedPrefix) && !mappedPrefix.equals(prefix)) {
                    send = !this._send;
                }
            }
        }
        return send;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.shouldSendElementEvent(uri, null, prefix, null)) {
            super.startPrefixMapping(prefix, uri);
        } else {
            this.lastPrefixRemoved = prefix;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (!prefix.equals(this.lastPrefixRemoved)) {
            super.endPrefixMapping(prefix);
        } else {
            this.lastPrefixRemoved = null;
        }
    }
}

