/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.application.Application;
import fr.gouv.culture.sdx.document.XMLDocument;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.framework.FrameworkImpl;
import fr.gouv.culture.sdx.pipeline.AbstractTransformation;
import fr.gouv.culture.sdx.search.Searchable;
import fr.gouv.culture.sdx.utils.Utilities;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.xml.EmbeddedXMLPipe;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GetDocumentsTransformation
extends AbstractTransformation {
    private boolean sendUserFields = true;
    private boolean sendInternalFields = false;
    private boolean sendSDXElements = true;
    private boolean sendAllFields = true;
    private boolean withinSdxElement = false;
    private boolean withinField = false;
    private boolean withinSdxInternalField = false;
    private boolean withinUserField = false;
    private String currentField = "";
    private String appId = "";
    private String dbId = "";
    private String docId = "";
    public static final String SEND_USER_FIELDS = "sendUserFields";
    public static final String SEND_INTERNAL_FIELDS = "sendInternalFields";
    public static final String SEND_SDX_ELEMENTS = "sendSDXElements";
    public static final String SEND_ALL_FIELDS = "sendAllFields";
    private final int UNKNOWN = -1;
    private final int START = 0;
    private final int CHARS = 1;
    private final int END = 2;
    private int currentEvent = -1;
    private String sUri = "";
    private String sLocal = "";
    private String sQName = "";
    private Attributes sAttr = null;
    private String eUri = "";
    private String eLocal = "";
    private String eQName = "";
    private char[] c = null;
    private int start = -1;
    private int len = -1;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
    }

    public void setParameters(Parameters p) {
        super.setParameters(p);
        this.loadSendParams();
    }

    private void loadSendParams() {
        if (this.getParameters() != null) {
            Parameters params = this.getParameters();
            String[] paramNames = params.getNames();
            for (int i = 0; i < paramNames.length; ++i) {
                try {
                    if (paramNames[i].equals(SEND_SDX_ELEMENTS)) {
                        this.sendSDXElements = new Boolean(params.getParameter(paramNames[i]));
                    }
                    if (paramNames[i].equals(SEND_ALL_FIELDS)) {
                        this.sendAllFields = new Boolean(params.getParameter(paramNames[i]));
                    }
                    if (paramNames[i].equals(SEND_INTERNAL_FIELDS)) {
                        this.sendInternalFields = new Boolean(params.getParameter(paramNames[i]));
                    }
                    if (!paramNames[i].equals(SEND_USER_FIELDS)) continue;
                    this.sendUserFields = new Boolean(params.getParameter(paramNames[i]));
                    continue;
                }
                catch (ParameterException e) {
                    Utilities.logException(this.logger, (Exception)((Object)e));
                }
            }
        }
        if (this.sendUserFields && this.sendInternalFields && !this.sendAllFields) {
            this.sendAllFields = true;
        }
        if (!this.sendUserFields && !this.sendInternalFields) {
            this.sendAllFields = false;
        }
        if (!this.sendInternalFields | !this.sendUserFields && this.sendAllFields) {
            this.sendAllFields = false;
        }
    }

    public void startElement(String uri, String local, String qName, Attributes attr) throws SAXException {
        this.setCurrentEvent(0);
        this.sUri = uri;
        this.sLocal = local;
        this.sQName = qName;
        this.sAttr = attr;
        this.determineParsingPosition(this.sUri, this.sLocal, this.sQName, this.sAttr);
        this.generateEvent();
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.withinSdxInternalField) {
            StringBuffer stringBuff = new StringBuffer();
            stringBuff.append(c, start, len);
            if (Utilities.checkString(this.currentField)) {
                if (this.currentField.equals("sdxappid")) {
                    this.appId = stringBuff.toString();
                }
                if (this.currentField.equals("sdxdocid")) {
                    this.docId = stringBuff.toString();
                }
                if (this.currentField.equals("sdxdbid")) {
                    this.dbId = stringBuff.toString();
                }
            }
        }
        this.setCurrentEvent(1);
        this.c = c;
        this.start = start;
        this.len = len;
        this.generateEvent();
    }

    public void endElement(String uri, String local, String qName) throws SAXException {
        this.setCurrentEvent(2);
        this.eUri = uri;
        this.eLocal = local;
        this.eQName = qName;
        this.determineParsingPosition(this.eUri, this.eLocal, this.eQName, null);
        this.generateEvent();
    }

    private void setCurrentEvent(int event) {
        this.currentEvent = event;
    }

    private void determineParsingPosition(String uri, String local, String qName, Attributes attr) {
        this.withinUserField = false;
        this.withinSdxInternalField = false;
        this.withinSdxElement = false;
        if (Utilities.checkString(uri)) {
            this.withinSdxElement = uri.equals("http://www.culture.gouv.fr/ns/sdx/sdx");
        }
        if (this.withinSdxElement) {
            if (Utilities.checkString(local) && local.equals("field")) {
                String fieldName;
                this.withinField = true;
                if (attr != null && Utilities.checkString(fieldName = attr.getValue("", "name"))) {
                    this.currentField = fieldName;
                }
                if (this.currentField.startsWith("sdx")) {
                    this.withinSdxInternalField = true;
                } else {
                    this.withinUserField = true;
                }
            } else {
                this.withinField = false;
            }
        }
    }

    private void generateEvent() throws SAXException {
        if (this.withinSdxElement) {
            if (this.sendSDXElements) {
                if (this.withinField) {
                    if (this.sendAllFields) {
                        this.sendEvent();
                    } else {
                        if (this.withinSdxInternalField && this.sendInternalFields) {
                            this.sendEvent();
                        }
                        if (this.withinUserField && this.sendUserFields) {
                            this.sendEvent();
                        }
                    }
                } else {
                    if (this.currentEvent == 2 && Utilities.checkString(this.eLocal) && this.eLocal.equals("result")) {
                        try {
                            this.getDocumentEvents();
                        }
                        catch (SDXException e) {
                            throw new SAXException(e.getMessage(), e);
                        }
                    }
                    this.sendEvent();
                }
            } else {
                if (this.currentEvent == 2 && Utilities.checkString(this.eLocal) && this.eLocal.equals("result")) {
                    try {
                        this.getDocumentEvents();
                    }
                    catch (SDXException e) {
                        throw new SAXException(e.getMessage(), e);
                    }
                }
                if (this.withinSdxInternalField && this.sendInternalFields) {
                    this.sendEvent();
                }
                if (this.withinUserField && this.sendUserFields) {
                    this.sendEvent();
                }
            }
        } else {
            this.sendEvent();
        }
    }

    private void sendEvent() throws SAXException {
        switch (this.currentEvent) {
            case 0: {
                this.contentHandler.startElement(this.sUri, this.sLocal, this.sQName, this.sAttr);
                this.resetEventValues();
                break;
            }
            case 1: {
                this.contentHandler.characters(this.c, this.start, this.len);
                this.resetEventValues();
                break;
            }
            case 2: {
                this.contentHandler.endElement(this.eUri, this.eLocal, this.eQName);
                this.resetEventValues();
                break;
            }
            default: {
                throw new SAXException("unable to determine event to send");
            }
        }
    }

    private void resetEventValues() throws SAXException {
        switch (this.currentEvent) {
            case 0: {
                this.sQName = "";
                this.sLocal = "";
                this.sUri = "";
                this.sAttr = null;
                break;
            }
            case 1: {
                this.c = null;
                this.start = -1;
                this.len = -1;
                break;
            }
            case 2: {
                this.eQName = "";
                this.eLocal = "";
                this.eUri = "";
                break;
            }
            default: {
                throw new SAXException("unable to determine event for which values need to be reset");
            }
        }
        this.setCurrentEvent(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getDocumentEvents() throws SDXException {
        block11: {
            if (this.manager == null) {
                throw new SDXException(this.logger, 221, null, null);
            }
            FrameworkImpl frame = null;
            try {
                block10: {
                    try {
                        Application app;
                        if (!Utilities.checkString(this.appId) || !Utilities.checkString(this.dbId) || !Utilities.checkString(this.docId) || (frame = (FrameworkImpl)this.manager.lookup("fr.gouv.culture.sdx.framework.Framework")) == null || (app = frame.getApplicationById(this.appId)) == null) break block10;
                        DocumentBase db = null;
                        Searchable searchable = app.getSearchable(this.dbId);
                        if (searchable instanceof DocumentBase) {
                            db = (DocumentBase)searchable;
                        }
                        if (db != null) {
                            XMLDocument doc = new XMLDocument(this.docId);
                            EmbeddedXMLPipe consumer = new EmbeddedXMLPipe(this.contentHandler);
                            db.getDocument(doc, (XMLConsumer)consumer, false);
                        }
                    }
                    catch (SDXException e) {
                        throw e;
                    }
                    catch (ComponentException e) {
                        throw new SDXException(this.logger, 222, null, e);
                    }
                }
                Object var8_9 = null;
                if (frame == null) break block11;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (frame != null) {
                    this.manager.release(frame);
                }
                this.resetDocRetrievalFields();
                throw throwable;
            }
            this.manager.release(frame);
        }
        this.resetDocRetrievalFields();
    }

    private void resetDocRetrievalFields() {
        this.currentField = null;
        this.docId = null;
        this.dbId = null;
        this.appId = null;
    }
}

