/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.query.Index;
import fr.gouv.culture.sdx.utils.SdxObjectImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Database;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public abstract class AbstractIDGenerator
extends SdxObjectImpl
implements IDGenerator {
    protected final String ATTRIBUTE_ID_PREFIX = "idPrefix";
    protected final String ATTRIBUTE_ID_SUFFIX = "idSuffix";
    protected Database _database = null;
    protected String idPrefix = "";
    protected String idSuffix = "";

    public void configure(Configuration configuration) throws ConfigurationException {
        if (configuration != null) {
            this.idPrefix = configuration.getAttribute("idPrefix", "");
            this.idSuffix = configuration.getAttribute("idSuffix", "");
        }
    }

    public String getSuffix() {
        return this.idSuffix;
    }

    public void setSuffix(String idSuffix) {
        this.idSuffix = idSuffix;
    }

    public String getPrefix() {
        return this.idPrefix;
    }

    public void setPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    public void setIndex(Index docBaseIndex) {
    }

    public void setDatabase(Database database) {
        this._database = database;
    }

    public boolean isIdUnique(String id) {
        if (!Utilities.checkString(id)) {
            return false;
        }
        if (this._database == null) {
            return true;
        }
        DatabaseEntity dbe = null;
        try {
            dbe = this._database.getEntity(id);
        }
        catch (SDXException e) {
            Utilities.logException(this.logger, e);
        }
        return dbe == null;
    }

    public void setIdFieldName(String fieldName) {
    }

    public String generate() {
        return this.generate(this.idPrefix, this.idSuffix);
    }
}

