/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.OAIObjectImpl;
import fr.gouv.culture.oai.OAIRequest;
import fr.gouv.culture.oai.util.OAIUtilities;
import java.util.Enumeration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.Request;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OAIRequestImpl
extends OAIObjectImpl
implements OAIRequest {
    protected String requestURL = null;
    protected String repoURL = null;
    protected int verb = -1;
    protected String verbString = "";
    protected String identifier = null;
    protected String metadataPrefix = null;
    String verbId = null;
    protected boolean useLastHarvestDate = true;
    protected String from = null;
    protected String until = null;
    protected String setIdentifier = null;
    protected String resumptionToken = null;
    protected Request cocoonRequest = null;

    public int getVerb() {
        return this.verb;
    }

    public void setVerb(int verb) {
        this.verb = verb;
        String verbStr = null;
        switch (this.verb) {
            case 0: {
                verbStr = "Identify";
                break;
            }
            case 1: {
                verbStr = "ListSets";
                break;
            }
            case 2: {
                verbStr = "ListMetadataFormats";
                break;
            }
            case 3: {
                verbStr = "ListIdentifiers";
                break;
            }
            case 4: {
                verbStr = "ListRecords";
                break;
            }
            case 5: {
                verbStr = "GetRecord";
            }
        }
        this.verbString = verbStr;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getVerbId() {
        return this.verbId;
    }

    public void setVerbId(String verbId) {
        this.verbId = verbId;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public void setMetadataPrefix(String metadataPrefix) {
        this.metadataPrefix = metadataPrefix;
    }

    public boolean getUseLastHarvestDate() {
        return this.useLastHarvestDate;
    }

    public void setUseLastHarvestDate(boolean useLastHarvestDate) {
        this.useLastHarvestDate = useLastHarvestDate;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String fromDate) {
        this.from = fromDate;
    }

    public String getUntil() {
        return this.until;
    }

    public void setUntil(String until) {
        this.until = until;
    }

    public String getSetIdentifier() {
        return this.setIdentifier;
    }

    public void setSetIdentifier(String setIdentifier) {
        this.setIdentifier = setIdentifier;
    }

    public String getResumptionToken() {
        return this.resumptionToken;
    }

    public void setResumptionToken(String resumptionToken) {
        this.resumptionToken = resumptionToken;
    }

    public String getRequestURL() {
        if (OAIUtilities.checkString(this.requestURL)) {
            return this.requestURL;
        }
        String rUrl = "";
        Parameters params = this.getParameters();
        if (params != null && OAIUtilities.checkString(this.repoURL)) {
            rUrl = rUrl + this.repoURL;
            String[] paramNames = params.getNames();
            for (int i = 0; i < paramNames.length; ++i) {
                String paramVal;
                String paramName = paramNames[i];
                if (!OAIUtilities.checkString(paramName) || !OAIUtilities.checkString(paramVal = params.getParameter(paramName, ""))) continue;
                rUrl = i == 0 ? rUrl + "?" + paramName + "=" + paramVal : rUrl + "&" + paramName + "=" + paramVal;
            }
        }
        return rUrl;
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public String getVerbString() {
        return this.verbString;
    }

    public void setVerbString(String verbString) {
        this.verbString = verbString;
        int verbInt = -1;
        verbInt = "Identify".equals(this.verbString) ? 0 : ("ListSets".equals(this.verbString) ? 1 : ("ListMetadataFormats".equals(this.verbString) ? 2 : ("ListIdentifiers".equals(this.verbString) ? 3 : ("ListRecords".equals(this.verbString) ? 4 : ("GetRecord".equals(this.verbString) ? 5 : -1)))));
        this.verb = verbInt;
    }

    public String getRepositoryURL() {
        return this.repoURL;
    }

    public void setRepositoryURL(String url) {
        this.repoURL = url;
    }

    public Request getRequest() {
        return this.cocoonRequest;
    }

    public void setRequest(Request coocoonRequest) {
        this.cocoonRequest = coocoonRequest;
        if (this.cocoonRequest != null) {
            String repoUrl = this.cocoonRequest.getScheme() + "://" + this.cocoonRequest.getServerName() + ":" + this.cocoonRequest.getServerPort() + this.cocoonRequest.getContextPath() + this.cocoonRequest.getServletPath();
            String requestUrl = repoUrl + "?" + this.cocoonRequest.getQueryString();
            this.setRepositoryURL(repoUrl);
            this.setRequestURL(requestUrl);
            this.setParameters();
        }
    }

    protected void setParameters() {
        Enumeration paramNames;
        if (this.cocoonRequest != null && (paramNames = this.cocoonRequest.getParameterNames()) != null) {
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                String paramVal = this.cocoonRequest.getParameter(paramName);
                if (!OAIUtilities.checkString(paramName = OAIUtilities.normalizeHttpRequestParameterName(paramName)) || !OAIUtilities.checkString(paramVal)) continue;
                if ("identifier".equals(paramName)) {
                    this.setIdentifier(paramVal);
                    continue;
                }
                if ("metadataPrefix".equals(paramName)) {
                    this.setMetadataPrefix(paramVal);
                    continue;
                }
                if ("set".equals(paramName)) {
                    this.setSetIdentifier(paramVal);
                    continue;
                }
                if ("from".equals(paramName)) {
                    this.setFrom(paramVal);
                    continue;
                }
                if ("until".equals(paramName)) {
                    this.setUntil(paramVal);
                    continue;
                }
                if ("resumptionToken".equals(paramName)) {
                    this.setResumptionToken(paramVal);
                    continue;
                }
                if (!"verb".equals(paramName)) continue;
                this.setVerbString(paramVal);
            }
        }
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        this.toSAX(contentHandler, true);
    }

    public void toSAX(ContentHandler handler, boolean sendRequestParams) throws SAXException {
        String repoUrl = this.getRepositoryURL();
        if (!OAIUtilities.checkString(repoUrl)) {
            String requestUrl = this.getRequestURL();
            int endIdx = requestUrl.indexOf("?");
            if (endIdx < 0) {
                endIdx = requestUrl.length();
            }
            repoUrl = requestUrl.substring(0, endIdx);
        }
        if (OAIUtilities.checkString(repoUrl)) {
            Parameters params;
            ContentHandler currentHandler = this.contentHandler;
            super.setContentHandler(handler);
            AttributesImpl atts = new AttributesImpl();
            if (sendRequestParams && (params = this.getParameters()) != null) {
                String[] paramNames = params.getNames();
                for (int i = 0; i < paramNames.length; ++i) {
                    String paramVal;
                    String paramName = paramNames[i];
                    if (!OAIUtilities.checkString(paramName) || !OAIUtilities.checkString(paramVal = params.getParameter(paramName, ""))) continue;
                    atts.addAttribute("", paramName, paramName, "CDATA", paramVal);
                }
            }
            super.startElement("http://www.openarchives.org/OAI/2.0/", "request", "request", atts);
            super.sendElementContent(repoUrl);
            super.endElement("http://www.openarchives.org/OAI/2.0/", "request", "request");
            super.setContentHandler(currentHandler);
        }
    }

    protected Parameters getParameters() {
        Parameters params = new Parameters();
        Request httpRequest = this.cocoonRequest;
        Enumeration paramNames = null;
        if (httpRequest != null) {
            paramNames = httpRequest.getParameterNames();
        }
        if (paramNames != null) {
            while (paramNames.hasMoreElements()) {
                String paramVal;
                String paramName = (String)paramNames.nextElement();
                if (!OAIUtilities.checkString(paramName) || !OAIUtilities.checkString(paramVal = httpRequest.getParameter(paramName))) continue;
                paramName = OAIUtilities.normalizeHttpRequestParameterName(paramName);
                params.setParameter(paramName, paramVal);
            }
        } else {
            if (OAIUtilities.checkString(this.verbString)) {
                params.setParameter("verb", this.verbString);
            }
            if (OAIUtilities.checkString(this.identifier)) {
                params.setParameter("identifier", this.identifier);
            }
            if (OAIUtilities.checkString(this.metadataPrefix)) {
                params.setParameter("metadataPrefix", this.metadataPrefix);
            }
            if (OAIUtilities.checkString(this.from)) {
                params.setParameter("from", this.from);
            }
            if (OAIUtilities.checkString(this.until)) {
                params.setParameter("until", this.until);
            }
            if (OAIUtilities.checkString(this.setIdentifier)) {
                params.setParameter("set", this.setIdentifier);
            }
            if (OAIUtilities.checkString(this.resumptionToken)) {
                params.setParameter("resumptionToken", this.resumptionToken);
            }
        }
        return params;
    }
}

